// FVEK -- more usage text
void usage(){
   printf("kterm %s\n", VERSION);
   printf("Usage: kterm [OPTION]\n");
   printf("        -c <0|1>     - color scheme (0 light, 1 dark)\n");
   printf("        -e <command> - execute command in kterm\n");
   printf("        -f <family>  - font family\n");
   printf("        -h           - show this message\n");
   printf("        -k <0|1>     - keyboard off/on\n");
   printf("        -s <size>    - font size\n");
   printf("        -v           - print version and exit\n");
   exit(0);
}

int main(int argc, char **argv){ 
  GtkWidget *window, *terminal, *vbox;
  GtkWidget *socket, *keyboard_box;
  unsigned long kb_xid;

  conf = parse_config(); // FVEK -- move this here so line options overide config

  // support for '-e' argument contributed by fvek
  char *cargv[255];
  char *argbuf;
  int c, i;
  cargv[0]=NULL;
  while((c = getopt(argc, argv, "c:e:f:hk:s:v")) != -1){ // FVEK -- more options
    switch(c){
      case 'e':
        argbuf = strtok(optarg, " ");
        i = 0;
        while(argbuf != NULL){
          cargv[i] = argbuf;
          i++;
          argbuf = strtok(NULL, " ");
        }
        cargv[i] = NULL;
        break;
// FVEK -start-
      case 'c':
        i = atoi(optarg);
        if ((i == 0) | (i == 1)) conf->color_scheme = i;
        break;
      case 'k':
        i = atoi(optarg);
        if ((i == 0) | (i == 1)) conf->kb_on = i;
        break;
      case 's':
        i = atoi(optarg);
        if (i > 0) conf->font_size = i;
        break;
      case 'f':
        snprintf(conf->font_family, sizeof(conf->font_family), "%s", optarg);
        break;
// FVEK -end-
      case 'h':
      case 'v':
        usage();
        break;
    }
  }

//  conf = parse_config(); // FVEK -- delete this, moved above

  gtk_init(&argc, &argv);

  install_signal_handlers();

  // launch keyboard
  kb_xid = launch_keyboard();
  if(!kb_xid){
    perror("matchbox-keyboard failed to return valid window ID\n");
    exit(1);
  }
  
  // window 
  //  \- vbox
  //      \- terminal_fixed  \- keyboard_fixed
  //         \- terminal        \- keyboard_box
  //                 
  // main window
  window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
  gtk_window_set_title(GTK_WINDOW(window), TITLE);
  gtk_window_set_decorated(GTK_WINDOW(window), FALSE);

  // box
  vbox = gtk_vbox_new(FALSE, 0);
  gtk_container_add(GTK_CONTAINER(window), vbox);

  // terminal
  putenv("PS1=[\\W]\\$ ");
  GtkWidget *terminal_fixed = gtk_fixed_new();
  gtk_widget_set_name(terminal_fixed, "termBoxFixed");
  terminal = vte_terminal_new();
  gtk_widget_set_name(terminal, "termBox");
  gtk_fixed_put(GTK_FIXED(terminal_fixed), terminal, 0, 0);
  set_box_size(terminal_fixed);
  set_terminal_colors(terminal, conf->color_scheme);
  vte_terminal_set_scrollback_lines(VTE_TERMINAL(terminal), VTE_SCROLLBACK_LINES);
  set_terminal_font(VTE_TERMINAL(terminal), conf->font_family, conf->font_size);
  vte_terminal_set_encoding(VTE_TERMINAL(terminal), VTE_ENCODING);
  vte_terminal_set_allow_bold(VTE_TERMINAL(terminal), TRUE);
  vte_terminal_fork_command(VTE_TERMINAL(terminal), 
                            cargv[0], 
                            (cargv[0] ? cargv : NULL), 
                            NULL, NULL, FALSE, FALSE, FALSE);
  gtk_box_pack_start(GTK_BOX(vbox), terminal_fixed, TRUE, TRUE, 0);

  // embed keyboard (XEMBED)
  GtkWidget *keyboard_fixed = gtk_fixed_new();
  gtk_widget_set_name(keyboard_fixed, "kbBoxFixed");
  keyboard_box = gtk_event_box_new();
  gtk_widget_set_name(keyboard_box, "kbBox");
  gtk_fixed_put(GTK_FIXED(keyboard_fixed), keyboard_box, 0, 0);
  set_box_size(keyboard_fixed);
  socket = gtk_socket_new();
  gtk_container_add(GTK_CONTAINER(keyboard_box), socket);
  gtk_box_pack_start(GTK_BOX(vbox), keyboard_fixed, TRUE, TRUE, 0);
  gtk_socket_add_id(GTK_SOCKET(socket), kb_xid); 

  // signals
  g_signal_connect(window, "destroy", G_CALLBACK(widget_destroy), NULL);
  g_signal_connect(window, "delete_event", G_CALLBACK(clean_and_exit), NULL);
  g_signal_connect(terminal, "child-exited", G_CALLBACK(terminal_exit), NULL);
  g_signal_connect(terminal, "button-press-event", G_CALLBACK(button_press), (gpointer) vbox);
  g_signal_connect(keyboard_box, "size-request", G_CALLBACK(set_box_size), NULL);
  g_signal_connect_swapped(window, "size-request", G_CALLBACK(set_box_size), terminal_fixed);
  g_signal_connect_swapped(window, "size-request", G_CALLBACK(set_box_size), keyboard_fixed);

  gtk_widget_show_all(window);

  // grab keyboard
  // this is necessary for kindle, because its framework intercepts some keystrokes
  Window root = DefaultRootWindow(GDK_DISPLAY());
  XGrabKeyboard(GDK_DISPLAY(), root, TRUE, GrabModeAsync, GrabModeAsync, CurrentTime);

  gtk_main();

  return 0;
}
