void set_terminal_colors(GtkWidget *terminal, int scheme){
  // light background
  GdkColor palette_light[8] = {{ 0, 0x0000, 0x0000, 0x0000 }, // black 
  { 0, 0x5050, 0x5050, 0x5050 }, // red
  { 0, 0x7070, 0x7070, 0x7070 }, // green
  { 0, 0xa0a0, 0xa0a0, 0xa0a0 }, // yellow
  { 0, 0x8080, 0x8080, 0x8080 }, // blue
  { 0, 0x3030, 0x3030, 0x3030 }, // magenta
  { 0, 0x9090, 0x9090, 0x9090 }, // cyan
  { 0, 0xffff, 0xffff, 0xffff }}; // white
  // dark background
  GdkColor palette_dark[8] = {{ 0, 0x0000, 0x0000, 0x0000 },
  { 0, 0x8888, 0x8888, 0x8888 },
  { 0, 0x9898, 0x9898, 0x9898 },
  { 0, 0xd0d0, 0xd0d0, 0xd0d0 },
  { 0, 0xa8a8, 0xa8a8, 0xa8a8 },
  { 0, 0x7070, 0x7070, 0x7070 },
  { 0, 0xb8b8, 0xb8b8, 0xb8b8 },
  { 0, 0xffff, 0xffff, 0xffff }};
  GdkColor *palette;
  GdkColor color_white = { 0, 0xffff, 0xffff, 0xffff };
  GdkColor color_black = { 0, 0x0000, 0x0000, 0x0000 };
  GdkColor color_grey = { 0, 0x8888, 0x8888, 0x8888 }; // FVEK
  GdkColor color_bg, color_fg;
  GdkColor color_dim = color_grey; // FVEK
  switch(scheme){
    default:
    case VTE_SCHEME_LIGHT:
      palette = palette_light;
      color_bg = color_white;
      color_fg = color_black;
      break;
    case VTE_SCHEME_DARK:
      palette = palette_dark;
      color_bg = color_black;
      color_fg = color_white;
      break;
  }
  vte_terminal_set_colors(VTE_TERMINAL(terminal), NULL, NULL, palette, 8);
  vte_terminal_set_color_background(VTE_TERMINAL(terminal), &color_bg);
  vte_terminal_set_color_foreground(VTE_TERMINAL(terminal), &color_fg);
// FVEK -start-
  vte_terminal_set_color_dim(VTE_TERMINAL(terminal), &color_dim);
  vte_terminal_set_color_bold(VTE_TERMINAL(terminal), &color_fg);
  vte_terminal_set_color_cursor(VTE_TERMINAL(terminal), &color_fg);
  vte_terminal_set_color_highlight(VTE_TERMINAL(terminal), &color_fg);
// FVEK -end-
  conf->color_scheme = scheme;
}
