/* MyDispatcher - Decompiled by JODE
 * Visit http://jode.sourceforge.net/
 */
package com.amazon.ebook.booklet.my;
import java.awt.EventQueue;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.ArrayList;

public class MyDispatcher implements KeyEventDispatcher
{
	private Controller cont;
	private HashMap[] layout;
	private String[] label;
	private long[] timeout;
	private int currentLayout;
	private boolean keyboardEnabled;
	private KeyboardFocusManager man;
	private KeyEvent ShiftEvent;
	private boolean ShiftConsumed;
	private boolean KeyCodeSent;
	private boolean labelInit;
	private char prev_c;
	private long prev_t;
	private long pressed_prev_t;
	private long simulated_t;
	private EventQueue eq;
	private final long init_timeout = 300;

	public MyDispatcher(Controller controller)
	{
		cont = controller;
		layout = new HashMap[11];
		label = new String[11];
		timeout = new long[11];
		layout[1] = new HashMap();
		label[1] = "en";
		timeout[1] = init_timeout;
		currentLayout = 1;
		keyboardEnabled = false;
		ShiftConsumed = false;
		labelInit = false;
		KeyCodeSent = false;
		prev_c = '\010';
		prev_t = 0;
		pressed_prev_t = 0;
		simulated_t = 0;
		EventQueue eventqueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
		man = KeyboardFocusManager.getCurrentKeyboardFocusManager();
		Field[] fields = java.awt.KeyboardFocusManager.class.getDeclaredFields();
		for (int i = 0; i < fields.length; i++)
		{
			cont.MyLog(fields[i].getName() + " " + fields[i].getType().getName());
			if ("keyEventDispatchers".equals(fields[i].getName()))
			{
				Field field = fields[i];
				field.setAccessible(true);
				try
				{
					cont.MyLog("Getting dispatchers list");
					Object[] objects = (Object[])field.get(man);
					cont.MyLog("Insert our handler");
					for (int i_0_ = 0; i_0_ < objects.length; i_0_++)
					{
						cont.MyLog(objects[i_0_].toString());
					}
					Object[] objects_1_ = new Object[objects.length + 1];
					System.arraycopy(objects, 0, objects_1_, 1, objects.length);
					objects_1_[0] = this;
					field.set(man, objects_1_);
					cont.MyLog("success");
				}
				catch(Exception exception)
				{
					cont.MyLog(exception.toString());
				}
				break;
			}
		}
		boolean doubles = new File("/mnt/us/keyboard/keyboard_european.txt").exists();
		boolean switchable = new File("/mnt/us/keyboard/keyboard.txt").exists();
		int next = 1;
		if (doubles)
		{
			loadTrans(new File("/mnt/us/keyboard/keyboard_european.txt"), 1);
			if ("kb1".equals(label[1]))
			{
				label[1] = "en ";
			}
			next = 2;
		}
		if (switchable)
		{
			loadTrans(new File("/mnt/us/keyboard/keyboard.txt"), 2);
			if ("kb2".equals(label[1]))
			{
				label[1] = "alt";
			}
			next = 3;
		}
		File dir = new File("/mnt/us/keyboard");
		File[] kbd = dir.listFiles(new java.io.FilenameFilter() {
			public boolean accept(File d, String name) { return name.endsWith(".kbd") && !name.startsWith("."); }
		});
		for (int i=next; i<10 && i < kbd.length + next; i++)
		{
			File f = kbd[i-next];
			if (f.exists())
			{
				loadTrans(f, i);
			}
		}
	}

	private void loadTrans(File file, int index)
	{
		if (file.exists())
		{
			FileInputStream fileinputstream;
			try
			{
				fileinputstream = new FileInputStream(file);
			}
			catch(FileNotFoundException filenotfoundexception)
			{
				cont.MyLog(filenotfoundexception.getMessage());
				return;
			}
			BufferedReader bufferedreader;
			try
			{
				bufferedreader = new BufferedReader(new InputStreamReader(fileinputstream, "UTF-8"));
			}
			catch(UnsupportedEncodingException unsupportedencodingexception)
			{
				cont.MyLog(unsupportedencodingexception.getMessage());
				return;
			}

			layout[index] = new HashMap();
			label[index] = file.getName().substring(0,3);
			timeout[index] = init_timeout;
			cont.MyLog("Reading: " + file.getAbsolutePath());
			try
			{
				String string;
				while ((string = bufferedreader.readLine()) != null)
				{
					if (string.indexOf("=") > 0)
					{
						String key = string.substring(0, string.indexOf("="));
						String value = string.substring(string.indexOf("=") + 1, string.length());
						if (key.equalsIgnoreCase("timeout"))
						{
							try
							{
								timeout[index] = Long.parseLong(value);
							}
							catch(NumberFormatException nfe)
							{
							}
						}
						else if (key.equalsIgnoreCase("enabledonstart") || key.equalsIgnoreCase("default"))
						{
							if ("true".equalsIgnoreCase(value) || "1".equalsIgnoreCase(value) || "yes".equalsIgnoreCase(value)) currentLayout = index;
						}
						else if (key.equalsIgnoreCase("label"))
						{
							label[index] = value;
						}
						else
						{
							layout[index].put(key, value);
							cont.MyLog(key + '=' + value);
						}
					}
				}
			}
			catch(IOException ioexception)
			{
				cont.MyLog(ioexception.getMessage());
				return;
			}
			keyboardEnabled = true;
		}
		else
		{
			cont.MyLog("File not found: " + file.getAbsolutePath());
		}
	}

	public boolean dispatchKeyEvent(KeyEvent keyevent)
	{
		if (keyboardEnabled)
		{
			if (!labelInit)
			{
				String[] cmd = { "/bin/sh", "-c", "/usr/sbin/eips 47 39 '" + label[currentLayout] + "'" };
				try
				{
					Process process = Runtime.getRuntime().exec(cmd);
				} catch (Exception e) {}
				labelInit = true;
			}
			cont.MyLog(keyevent.toString());
			char c = keyevent.getKeyChar();
			long prev_t_save = prev_t;
			String replacement = "";
			boolean isDouble = false;
			if (keyevent.getID() == KeyEvent.KEY_TYPED && c != '\n' && keyevent.getWhen() != prev_t)
			{
				if (keyevent.getWhen() - prev_t > timeout[currentLayout])
				{
					cont.MyLog("Timed out (" + timeout[currentLayout] + "ms), reset prev_c");
					prev_c = '\010';
				}
				String string = String.valueOf(prev_c) + String.valueOf(c);
				prev_c = c;
				prev_t = keyevent.getWhen();
				if (layout[currentLayout].containsKey(string))
				{
					cont.MyLog("Looking up double: '" + string + "'");
					prev_c = '\010';
					keyevent.consume();
					replacement = (String) layout[currentLayout].get(string);
					isDouble = true;
				}
			}
			if (keyevent.getKeyCode() == KeyEvent.VK_SHIFT && keyevent.getID() == KeyEvent.KEY_PRESSED)
			{
				ShiftEvent = keyevent;
				ShiftConsumed = true;
				return true;
			}
			if (c == '\n' && keyevent.isShiftDown())
			{
				keyevent.consume();
				if (keyevent.getID() == KeyEvent.KEY_PRESSED)
				{
					for (int i=currentLayout+1; i<=10; i++)
					{
						if (i == 10) i = 1;
						if (layout[i] != null)
						{
							currentLayout = i;
							break;
						}
					}
					cont.MyLog("Switched to layout: " + String.valueOf(currentLayout) + ", label: " + label[currentLayout]);
					String[] cmd = { "/bin/sh", "-c", "/usr/sbin/eips 47 39 '" + label[currentLayout] + "'" };
					try
					{
						Process process = Runtime.getRuntime().exec(cmd);
					} catch (Exception e) {}
				}
				ShiftConsumed = false;
				return true;
			}
			if (ShiftConsumed)
			{
				man.dispatchEvent(ShiftEvent);
				cont.MyLog("Shift state redispatched");
			}
			if (ShiftConsumed)
			{
				c = Character.toUpperCase(c);
			}
			String string = String.valueOf(c);
			if (replacement.length() == 0 && layout[currentLayout].containsKey(string) && keyevent.getWhen() != prev_t_save)
			{
				cont.MyLog("Looking up single: '" + string + "'");
				replacement = (String) layout[currentLayout].get(string);
			}
			boolean isKeyCode = false;
			if (replacement.length() == 0 && keyevent.getID() == KeyEvent.KEY_PRESSED && keyevent.getWhen() != pressed_prev_t && !KeyCodeSent)
			{
				replacement = (String) layout[currentLayout].get("#" + String.valueOf(keyevent.getKeyCode()));
				if (replacement == null)
				{
					replacement = "";
				}
				else
				{
					cont.MyLog("Looking up keycode: '" + String.valueOf(keyevent.getKeyCode()) + "'");
					isKeyCode = true;
				}
			}
			if (keyevent.getID() == KeyEvent.KEY_PRESSED)
			{
				KeyCodeSent = false;
				pressed_prev_t = keyevent.getWhen();
			}
			if (keyevent.getID() != KeyEvent.KEY_TYPED && keyevent.getWhen() == simulated_t)
			{
				cont.MyLog("Looks like a simulated event, ignoring");
			}
			if (replacement.length() != 0 && ( keyevent.getID() != KeyEvent.KEY_TYPED || keyevent.getWhen() != simulated_t ) )
			{
				if (isDouble)
				{
					man.dispatchEvent(new KeyEvent(keyevent.getComponent(), KeyEvent.KEY_PRESSED, System.currentTimeMillis(), 0, 8, '\uffff'));
					man.dispatchEvent(new KeyEvent(keyevent.getComponent(), KeyEvent.KEY_TYPED, System.currentTimeMillis(), 0, 0, '\010'));
					man.dispatchEvent(new KeyEvent(keyevent.getComponent(), KeyEvent.KEY_RELEASED, System.currentTimeMillis(), 0, 8, '\uffff'));
				}
				if (replacement.length() > 2 && replacement.charAt(0) == '#' && (replacement.charAt(1) == 'k' || replacement.charAt(1) == 'f' || replacement.charAt(1) == 'v'))
				{
					if (keyevent.getID() == KeyEvent.KEY_PRESSED)
					{
						String proc_file = "";
						switch (replacement.charAt(1))
						{
						case 'k':
							proc_file = "/proc/keypad";
							break;
						case 'f':
							proc_file = "/proc/fiveway";
							break;
						case 'v':
							proc_file = "/proc/volume";
							break;
						}
						cont.MyLog("Proc file: " + proc_file);
						if (proc_file.length() > 0)
						{
							String key_code = replacement.substring(2);
							try
							{
								cont.MyLog("Sending code " + key_code + "\n");
								BufferedWriter proc_writer = new BufferedWriter(new FileWriter(proc_file));
								proc_writer.write("send " + key_code + "\n");
								proc_writer.close();
								KeyCodeSent = true;
							}
							catch(IOException ioexception)
							{
								cont.MyLog(ioexception.getMessage());
							}
						}
					}
					else
					{
						cont.MyLog("Ignoring other than KEY_PRESSED event\n");
					}
					return true;
				}
				else
				{
					if (replacement.length() == 1 && !isDouble && !isKeyCode)
					{
						keyevent.setKeyChar(replacement.charAt(0));
						cont.MyLog("Translated to: " + keyevent.getKeyChar());
						if (keyevent.getID() == KeyEvent.KEY_TYPED) simulated_t = keyevent.getWhen();
					}
					else if ((keyevent.getID() == KeyEvent.KEY_PRESSED && isKeyCode) || (keyevent.getID() == KeyEvent.KEY_TYPED && !isKeyCode) || isDouble)
					{
						cont.MyLog("Translated to: " + replacement);
						long millis = System.currentTimeMillis();
						simulated_t = millis;
						for (int pos = 0; pos < replacement.length(); pos++)
						{
							man.dispatchEvent(new KeyEvent(keyevent.getComponent(), KeyEvent.KEY_TYPED, millis, 0, 0, replacement.charAt(pos)));
						}
						return true;
					}
				}
			}
			else if (ShiftConsumed)
			{
				keyevent.setKeyChar(Character.toUpperCase(keyevent.getKeyChar()));
			}
			if (ShiftConsumed && keyevent.getID() == KeyEvent.KEY_TYPED)
			{
				ShiftConsumed = false;
			}
		}
		return false;
	}
}
