#! /bin/sh
#

HACKNAME="physkeyb"
PKGNAME="${HACKNAME}"
PKGVER="3.4.5-ukr"

KINDLE_MODELS="k3g k3w k3gb"
for model in ${KINDLE_MODELS} ; do
	# Prepare our files for this specific kindle model...
	ARCH=${PKGNAME}_${PKGVER}_${model}

	# Build install update
	./kindle_update_tool.py m --sign --${model} ${ARCH}_install physkeyb.jar ukrainian.kbd kindle.kbd install.sh README

	# Build uninstall update
	./kindle_update_tool.py m --sign --${model} ${ARCH}_uninstall uninstall.sh
done

# Pack the updates
zip ../${PKGNAME}_${PKGVER}.zip *.bin
rm -f *.bin
