#!/bin/sh
# aloop.sh last update 20130122 / stepk

# Each json menu entry must not extend on multiple lines; example valid entry:
#   {"name": "commas", "priority": 3, "action"  : "bin/script.sh", "params": "p1,p2,p3"}
# with or without a traling comma

# Tested on KT 5.1.2 only. UTF-8 support untested (depends on KT sh anyway).

# Look at 'main' further down, that's the main loop, just define EXTENSIONDIR there.
# Look at function make_label further down, you need to adapt it to generate and process pretty labels from sh variables.
# The main loop automatically creates a set of variables from xml and json files and calls make_label.
# The current make_label function is a stub that prints names and values of parsed variables.
# Creating a pretty label is a matter of assembling the available variables as you see fit, for instance:
#   pretty_label="$xml_name : $json_name : $json_action"
# which would result in i.e.,
#   pretty_label="Orientation : Portrait : bin/setorientation.sh"
# Of course make_label can also generate the command string, for instance you could define:
#   command="$json_action $json_params"
# which would result in i.e.,
#   oommand="bin/setorientation.sh U"

# json_var creates sh variable json_NAME from parsed data
json_var () {
  local s x=$*
#echo "json_var_1($#)($x)"
  x=json_${x:1}
  x=${x/\"/}
  until [[ "$s" = "$x" ]]; do
    s=$x
    x=${s/[ \t]:/:}
    x=${x/:[ \t]/:}
  done
  x=${x/:/=}
#echo "json_var_2 x($x)"
  eval $x
}

# usage: json_parse menu.json [foo]
# creates json vars for each line that matches "action"
# and calls function foo, which is supposed to do somenthing with json vars
# note: unset json_* vars before calling json_parse
json_parse () {
local line implode prev s x v menu=$1 foo=$2
shift 2     
while read line; do
  case $line in
  *"action"*)
    unset implode prev s
    line=${line#[\{\[]} # ltrim { and [ - [ isn't valid json but I've seen this typo in helper/menu.json
    until [[ "$s" = "$line" ]]; do
	  s=$line
	  line=${s%%[ \t\}\],]} # rtrim
    done
    # process comma-separated list of "id":"value" pairs
    IFS=,
    for x in $line; do
      x=${x## } # cases '"id":"v"' / '"id":"v1' / 'v2"' (last 2 for "id":"v1,v2")
#echo "X($x)"
      if [[ \" = ${x:0:1} ]]; then
        [[ $implode ]] && json_var $implode && unset implode
        [[ $prev ]] && json_var $prev
        prev=$x
#echo "PREV($x)"
      else
        implode=${implode}${implode:+,}$x
#echo "IMP($implode)"
      fi
    done
    if [[ "$prev" && "$implode" ]]; then
#echo "FINPREVIMP($prev,$implode)"
      json_var $prev,$implode
    elif [[ $implode ]]; then
#echo "FINIMP($implode)"
      json_var $implode
    elif [[ $prev ]]; then
#echo "FINPREV($prev)"
      json_var $prev
    fi
    unset IFS
    $foo $* # busybox can't support commented-out block below
#available in genuine bash only
#    if [[ function = `type -t $foo` ]]
#    then
#      $foo $*
#    else
#      echo -n "${0##*/} parsed:"
#      for v in ${!json_*}; do
#        echo -n " $v(${!v})"
#      done
#      echo -n "json_name($json_name) json_action($json_action) json_params($json_params) json_priority($json_priority)"
#      echo
#    fi
  ;;          
  esac
done < $menu
}

# usage: xml_var config.xml NAME
# xml_var creates a single variable xml_NAME from file config.xml
# note: unset var xml_NAME before calling xml_var
xml_var () {
  local line
  while read line; do
    case $line in
    *\<$2\>*)
      line=${line#*\<$2\>}
      line=${line%\</$2\>*}
      eval xml_$2=$line
      break
    ;;
    esac
  done < $1
}

# create pretty label
make_label () {
  echo -n make_label@$1 use sh variables:
  echo -n " xml_name($xml_name)"
  echo -n " json_name($json_name) json_action($json_action) json_params($json_params) json_priority($json_priority)"
  echo
}

# main
EXTENSIONDIR=/mnt/us/extensions
#EXTENSIONDIR=/root/Desktop/Downloads/kindle-KT5/INSTALLED/launcher

for f in $(find $EXTENSIONDIR/ -name menu.json); do
  unset xml_name json_name json_action json_params json_priority
  p=${f%menu.json} # path to menu.json and config.xml, if any
  if [[ -f $p/config.xml ]]; then
    xml_var $p/config.xml name
#echo "xml_name($xml_name)"
  fi
  json_parse $f make_label $p
done