#!/bin/sh

# diff OTA patch script 

_FUNCTIONS=/etc/rc.d/functions
[ -f ${_FUNCTIONS} ] && . ${_FUNCTIONS}


MSG_SLLVL_D="debug"
MSG_SLLVL_I="info"
MSG_SLLVL_W="warn"
MSG_SLLVL_E="err"
MSG_SLLVL_C="crit"
MSG_SLNUM_D=0
MSG_SLNUM_I=1
MSG_SLNUM_W=2
MSG_SLNUM_E=3
MSG_SLNUM_C=4
MSG_CUR_LVL=/var/local/system/syslog_level

logmsg()
{
    local _NVPAIRS
    local _FREETEXT
    local _MSG_SLLVL
    local _MSG_SLNUM

    _MSG_LEVEL=$1
    _MSG_COMP=$2

    { [ $# -ge 4 ] && _NVPAIRS=$3 && shift ; }

    _FREETEXT=$3

    eval _MSG_SLLVL=\${MSG_SLLVL_$_MSG_LEVEL}
    eval _MSG_SLNUM=\${MSG_SLNUM_$_MSG_LEVEL}

    local _CURLVL

    { [ -f $MSG_CUR_LVL ] && _CURLVL=`cat $MSG_CUR_LVL` ; } || _CURLVL=1

    if [ $_MSG_SLNUM -ge $_CURLVL ]; then
        /usr/bin/logger -p local4.$_MSG_SLLVL -t "ota_install" "$_MSG_LEVEL def:$_MSG_COMP:$_NVPAIRS:$_FREETEXT"
    fi

    [ "$_MSG_LEVEL" != "D" ] && echo "ota_install: $_MSG_LEVEL def:$_MSG_COMP:$_NVPAIRS:$_FREETEXT"
    [ -d /mnt/us/keyboard ] && echo "ota_install: $_MSG_LEVEL def:$_MSG_COMP:$_NVPAIRS:$_FREETEXT" >> /mnt/us/keyboard/install.log
}

if [ -z "${_PERCENT_COMPLETE}" ]; then
    export _PERCENT_COMPLETE=0
fi

update_percent_complete()
{
    _PERCENT_COMPLETE=$((${_PERCENT_COMPLETE} + $1))
    update_progressbar ${_PERCENT_COMPLETE}
}

logmsg "I" "update" "Create dirs"
#Create keyboard support dir at user store
[ -d /mnt/us/keyboard ] || mkdir /mnt/us/keyboard

update_percent_complete 30

logmsg "I" "update" "Copy files"
#in case
if [ -d /opt/amazon/ebook/booklet_loc ]; then
	logmsg "I" "update" "Copy to booklet_loc"
	cp -f physkeyb.jar /opt/amazon/ebook/booklet_loc/physkeyb.jar >> /mnt/us/keyboard/install.log 2>&1
else if [ -d /opt/amazon/ebook/booklet_ru ]; then
				logmsg "I" "update" "Copy to booklet_ru"
				cp -f physkeyb.jar /opt/amazon/ebook/booklet_ru/physkeyb.jar >> /mnt/us/keyboard/install.log 2>&1
		 else if [ -d /opt/amazon/ebook/booklet ]; then
							logmsg "I" "update" "Copy to booklet"
							cp -f physkeyb.jar /opt/amazon/ebook/booklet/physkeyb.jar >> /mnt/us/keyboard/install.log 2>&1
					fi
		 fi
fi

update_percent_complete 80
logmsg "I" "update" "Copy to /mnt/us/keyboard"
mv -f kindle.kbd /mnt/us/keyboard >> /mnt/us/keyboard/install.log 2>&1
mv -f ukrainian.kbd /mnt/us/keyboard >> /mnt/us/keyboard/install.log 2>&1

update_progressbar 100

return 0
