#!/mnt/ext1/system/bin/bash
# This script looks through the system/state and system/config/Active\ Contents
# directories and removes data for ebooks that are no longer on the device.

FIND=/mnt/ext1/system/bin/find

handle_af0 ()
{
  ebook=`echo "$1" | sed -e 's/.af0$//'`
  if [ ! -f /mnt/ext1/"$ebook" -a ! -f /mnt/ext2/"$ebook" ];
  then
    echo removing "$ebook"
    rm -rf "$ebook".*
  else
    echo keeping "$ebook"
  fi
}

handle_notes ()
{
  ebook=`grep filepath "$1" | cut -d '"' -f 2`
  MD5SUM=`grep md5sum "$1" | cut -d '"' -f 2`
  DELETE="no"
  if [ -f "$ebook" ];
  then
    MD5SUM_FILE=`md5sum "$ebook" | cut -d " " -f 1`
    if [ "$MD5SUM" != "$MD5SUM_FILE" ];
    then
      DELETE="yes"
    fi
  else
    DELETE="yes"
  fi
  if [ "$DELETE" == "yes" ];
  then
    echo deleting "$1"
    rm -rf `basename "$1" .html`.*
  else
    echo keeping "$1"
  fi
}

cd /mnt/ext1/system/state

IFS="
"
AFOS=(`$FIND . -name '*.af0'`)
i=0
while [ $i -lt ${#AFOS[@]} ]
do
  handle_af0 ${AFOS[$i]}
  i=$((i+1))
done

# Clean up empty directories
$FIND . -type d -empty -delete

cd /mnt/ext1/system/config/Active\ Contents

NOTES=(`$FIND . -name '*.html'`)
i=0
while [ $i -lt ${#NOTES[@]} ]
do
  handle_notes ${NOTES[$i]}
  i=$((i+1))
done

$FIND . -type d -empty -delete
