from calibre_plugins.docx_input_plugin.docx_input import DocxInput
__license__ = 'GPL 3'
__copyright__ = '2012 Saulius P.'
__docformat__ = 'restructuredtext en'

import os

class OpfWriter():
    
    def __init__(self, opfName, htmlList, context):
        self._htmlList = htmlList
        self._styleList = context.cssList
        self._fontList = context.fontList
        self._relList = context.relations
        self._opfName = opfName
        self._opts = context.opts
        self._oh = None
    
    def write(self):
        self._oh = open(self._opfName+'.opf', 'w')
        self._writeHeader()
        self._writeManifest()
        self._writeSpine()
        self._writeGuide()
        self._writeFooter()
        self._oh.close()
        return os.path.abspath(self._opfName+'.opf')
        
    def _writeHeader(self):
        self._oh.write('''<?xml version='1.0' encoding='utf-8'?>
        <package xmlns="http://www.idpf.org/2007/opf" version="2.0" unique-identifier="uuid_id">
          <metadata xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:opf="http://www.idpf.org/2007/opf" xmlns:dcterms="http://purl.org/dc/terms/" xmlns:calibre="http://calibre.kovidgoyal.net/2009/metadata" xmlns:dc="http://purl.org/dc/elements/1.1/">
            <dc:publisher>E</dc:publisher>
          </metadata>
        ''')
        
    def _writeManifest(self):
        self._oh.write('<manifest>')
        for hf in self._htmlList:
            if hf == '001' and len(self._htmlList) > 1 and self._opts.skip_first_pg is True:
                continue
            self._oh.write('''
                <item href="%s.html" id="id%s" media-type="application/xhtml+xml"/>
            ''' % (hf, hf))
        print 'Skip firstpg, cover: ', self._opts.skip_first_pg, self._opts.first_cover
        
        if self._styleList is not None:
            for sf in self._styleList:
                self._oh.write('''
                    <item href="%s.css" id="css" media-type="text/css"/>
                ''' % sf)
        #print 'OpfWriter::Embed fonts: ', self._opts.fonts_embed
        if self._fontList is not None:
            fontId = 1
            for font in self._fontList:
                self._oh.write('''
                    <item href="%s" id="idfont%d" media-type="application/vnd-ms-opentype"/>
                ''' % (font[2], fontId))
                fontId += 1
        if self._relList is not None:
            for key, rel in self._relList.iteritems():
                if rel.used or (self._opts.first_cover and rel.target.startswith('word/media/image1.')):
                    print 'Writing rel: ', rel.target
                    relName, relExt = os.path.split(rel.target)
                    self._oh.write('''
                        <item href="%s" id="%s" media-type="%s"/>
                    ''' % (rel.target, rel.id, self._getImageMime(relExt)))
        self._oh.write('</manifest>')   
        
    def _writeSpine(self):
        self._oh.write('<spine toc="ncx">')
        for hf in self._htmlList:
            if hf == '001' and len(self._htmlList) > 1 and self._opts.skip_first_pg is True:
                continue
            self._oh.write('''
               <itemref idref="id%s"/>
            ''' % hf)
        self._oh.write('</spine>')
    
    def _writeGuide(self):
        if self._opts.first_cover:
            for k, r in self._relList.iteritems():
                if r.target.startswith('word/media/image1.'):
                    fn, fex = os.path.splitext(r.target)
                    cname = 'word/media/cover'+fex
                    with open(r.target, 'rb') as fread:
                        with open(cname, 'wb') as fwrite:
                            fwrite.write(fread.read())
                            
                    self._oh.write('''
                    <guide>
                    <reference type="cover" title="Cover" href="%s"/>
                    </guide>
                    ''' % cname)
                    break
        
    def _writeFooter(self):
        self._oh.write('''
        </package>
        ''')
    
    def _getImageMime(self, img):
        if img is None or img == '':
            return 'application/octet-stream'
        if img.lower().endswith('jpg') or img.lower().endswith('jpeg') or img.lower().endswith('jpe'):
            return 'image/jpeg'
        if img.lower().endswith('gif'):
            return 'image/gif'
        if img.lower().endswith('png'):
            return 'image/png'
        else:
            return 'application/octet-stream'
        