from calibre_plugins.docx_input_plugin.docx_input import DocxInput

class HtmlWriter:
    def __init__(self, context):
        self._fh = None
        self._counter = 0
        self._files_written = []
        self._context = context
        #print('Initialize HtmlWriter')
    
    def open(self, title=None, prefix='', counterOverride=None):
        if self._fh is not None:
            self.close()
        self._counter += 1
        self._context.htmlCount = self._counter
        if counterOverride is None:
            fName = prefix+('%d' % self._counter).zfill(3)
        else:
            fName = prefix+('%d' % counterOverride).zfill(3)
        #print('HtmlWriter::open: opening %s' % (fName+'.html'))
        self._fh = open(fName+'.html', 'w')
        if title is None:
            title = fName
        self._writeHeader(title)
        self._files_written.append(fName)
        
    def write(self, str):
        #print('HtmlWriter::write')
        self._fh.write(str)
    
    def close(self):
        #print('HtmlWriter::close')
        self._writeFooter()
        self._fh.close()
        self._fh = None
        
    def reset(self):
        if self._fh is not None:
            self.close()
        self._fh = None
        self._counter = 0
        self._context.htmlCount = self._counter
        self._files_written = []
        
    def getFilesWritten(self):
        return self._files_written
        
    def _writeHeader(self, title):
        #print('HtmlWriter::_writeHeader')
        version, subversion, minor = DocxInput.version
        self._fh.write('''<?xml version='1.0' encoding='utf-8'?>
        <html xmlns="http://www.w3.org/1999/xhtml">
          <head>
            <meta content="DOCX Input by SauliusP., v%d.%d.%d" name="Generator"/>
            <title>%s</title>
            <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
          <link href="style.css" type="text/css" rel="stylesheet"/>
        </head>
          <body class="calibre">
        ''' % (version, subversion, minor, title))
        
    def _writeFooter(self):
        #print('HtmlWriter::_writeFooter')
        self._fh.write('''
        </body>
        </html>
        ''')
    