__license__ = 'GPL 3'
__copyright__ = '2012 Saulius P.'
__docformat__ = 'restructuredtext en'

import os
from calibre_plugins.docx_input_plugin.gui.docx_input_ui import prefs

class FontWriter:
    def __init__(self, context):
        self._context = context
        
    def write(self):
        os.mkdir('fonts')
        fontList = []
        for ff in self._context.fontStyles.keys():
            if ff in prefs['font_library']:
                for fs in self._context.fontStyles[ff]:
                    if fs in prefs['font_library'][ff]:
                        wrfs = fs
                    elif 'Default' in prefs['font_library'][ff]:
                        wrfs = prefs['font_library'][ff]['Default']
                    else:
                        wrfs = None
                    
                    if wrfs is not None:
                        fr = open(prefs['font_library'][ff][wrfs], 'rb')
                        font = fr.read()
                        fr.close
                        fName = 'fonts'+os.sep+ff.replace(' ', '')+'-'+wrfs+'.ttf'
                        f = open(fName, 'wb')
                        f.write(font)
                        f.close()
                        fontList.append([ff, wrfs, fName])
        return fontList
