__license__ = 'GPL 3'
__copyright__ = '2012 Saulius P.'
__docformat__ = 'restructuredtext en'

class CssWriter():
    def __init__(self, name, context):
        self._name = name
        self._styles = context.styles
        self._fontList = context.fontList
        self._opts = context.opts
        self._context = context
    
    def write(self):
        f = open(self._name+'.css', 'w')
        
        if self._fontList is not None:
            for font in self._fontList:
                f.write("@font-face{font-family:\"%s\";%ssrc:url('%s')}\n" % (font[0], self._getFontStyle(font[1]), font[2]))
        f.write("body{margin-left:2%;margin-right:2%;margin-top:2%;margin-bottom:2%}\n")

        for k, v in self._styles.iteritems():
            if v.TYPE == 'P' and (v.used or v.default):
                if v.default:
                    f.write("p {%s%smargin-top:0;margin-bottom:0;}\n" % (v.getFontCss(), v.paragraphProperties.getCss()))
                elif v.paragraphProperties.outline is not None:
                    f.write("h%d.%s {%s%s}\n" % ((v.paragraphProperties.outline+1), v.getCssId(), v.getFontCss(), v.paragraphProperties.getCss()))
                else:
                    f.write(".%s {%s%s}\n" % (v.getCssId(), v.getFontCss(), v.paragraphProperties.getCss()))
            elif v.TYPE == 'C' and v.used:
                f.write(".%s {%s}\n" % (v.getCssId(), v.fontProperties.getCss()))
        f.close()
    
    def _getFontStyle(self, style):
        if style == 'Regular':
            return 'font-style:normal;font-weight:normal;'
        elif style == 'Bold':
            return 'font-style:normal;font-weight:bold;'
        elif style == 'Italic':
            return 'font-style:italic;font-weight:normal;'
        elif style == 'BoldItalic':
            return 'font-style:italic;font-weight:bold;'
        else:
            return ''
        