class FontProperties:
    PROPS = ['bold', 'italic', 'caps', 'size', 'color', 'strike', 'underline', 'vertAlign', 'fontFamily', 'highlightColor']
    
    def __init__(self, context):
        self._context = context
        self.bold = None
        self.italic = None
        self.caps = None
        self.size = None
        self.color = None
        self.strike = None
        self.underline = None
        self.vertAlign = None
        self.fontFamily = None
        self.highlightColor = None
    
    def merge(self, fontProperties):
        if fontProperties.bold is not None:
            self.bold = fontProperties.bold
        if fontProperties.italic is not None:
            self.italic = fontProperties.italic
        if fontProperties.caps is not None:
            self.caps = fontProperties.caps
        if fontProperties.size is not None:
            self.size = fontProperties.size
        if fontProperties.color is not None:
            self.color = fontProperties.color
        if fontProperties.strike is not None:
            self.strike = fontProperties.strike
        if fontProperties.underline is not None:
            self.underline = fontProperties.underline
        if fontProperties.vertAlign is not None:
            self.vertAlign = fontProperties.vertAlign
        if fontProperties.fontFamily is not None:
            self.fontFamily = fontProperties.fontFamily
        if fontProperties.highlightColor is not None:
            self.highlightColor = fontProperties.highlightColor
        
    #def getFontSizeEm(self):
    #    if self.size is None:
    #        return None
    #    return round(float(self.size)/2.)/10
    
    def getFontSize(self, units='pt', prefix=True):
        if self.size is None:
            return None
        if units=='pt':
            ret = float(self.size)/2.
        elif units=='em':
            ret = round(float(self.size)/2.)/10
        elif units=='%':
            ret = float(self.size/20.)*100
        elif units=='px':
            ret = float(self.size)/16*12
        else:
            raise 'Units type "'+units+'" is not supported.'
        if prefix is True:
            return '%f%s' % (ret, units)
        else:
            return '%f' % ret
    
    def getCss(self, bold=True, italic=True, defaults=True):
        css = ''
        decoration = ''
        if bold is True and self.bold is True:
            css += 'font-weight: bold;'
        elif self.bold is False:
            css += 'font-weight: normal;'
        if italic is True and self.italic is True:
            css += 'font-style:italic;'
        elif self.italic is False:
            css += 'font-style:normal;'
        if self.size is not None:
            css += ('font-size: %s' % self.getFontSize())+';'
        elif defaults:
            css += 'font-size: 10pt;'
        if self.caps is True:
            css += 'text-transform:uppercase;'
        if self.color is not None:
            if self.color.lower() == 'auto':
                css += 'color: black;'
            else:
                css += 'color: #'+self.color+';'
        if self.strike is True:
            decoration += ' line-through'
        if self.underline is True:
            decoration += ' underline'
        if decoration != '':
            css+= 'text-decoration:'+decoration+';'
        if self.fontFamily is not None:
            if self._context.opts.font_embed is None or self._context.opts.font_embed == _('All'):
                css+= "font-family:'%s';" % self.fontFamily
            elif self._context.opts.font_embed == _('DejaVu Serif'):
                css+= "font-family:'DejaVu Serif',serif;"
            else:
                css+= 'font-family:serif;'
        
        if self.highlightColor is not None:
            if self.highlightColor[0].lower() == self.highlightColor[0] and not self.highlightColor[0].isdigit():
                css += 'background-color: %s;' % self.highlightColor
            else:
                css += 'background-color: #%s;' % self.highlightColor
        
        return css
        
    def debug(self):
        print("FontProperties:")
        print("          bold", self.bold)
        print("        italic", self.italic)
        print("          caps", self.caps)
        print("          size", self.size)
        print("     size smth", self.getFontSize())
        print("         color", self.color)
        
class ParagraphProperties:
    PROPS = ['pageBreak', 'align', 'firstLine', 'indLeft', 'indRight', 'before', 'after', 'outline', 'dropCap', 'shadeColor']
    
    def __init__(self, context):
        self._context = context
        self.pageBreak = None
        self.align = None
        self.firstLine = None
        self.indLeft = None
        self.indRight = None
        self.before = None
        self.after = None
        self.outline = None
        self.dropCap = False
        self.shadeColor = None
        self.list = False
    
    def merge(self, paragraphProperties):
        if paragraphProperties.pageBreak is not None:
            self.pageBreak = paragraphProperties.pageBreak
        if paragraphProperties.align is not None:
            self.align = paragraphProperties.align
        if paragraphProperties.firstLine is not None:
            self.firstLine = paragraphProperties.firstLine
        if paragraphProperties.indLeft is not None:
            self.indLeft = paragraphProperties.indLeft
        if paragraphProperties.indRight is not None:
            self.indRight = paragraphProperties.indRight
        if paragraphProperties.before is not None:
            self.before = paragraphProperties.before
        if paragraphProperties.after is not None:
            self.after = paragraphProperties.after
        if paragraphProperties.outline is not None:
            self.outline = paragraphProperties.outline
        if paragraphProperties.dropCap is not None:
            self.dropCap = paragraphProperties.dropCap
        if paragraphProperties.shadeColor is not None:
            self.shadeColor = paragraphProperties.shadeColor
        self.list = paragraphProperties.list 
        
    def getFirstLineValueEm(self):
        if self.firstLine is None:
            if self.list is False:
                return None
            else:
                return -1
        
        fl = round(float(self.firstLine)/20.)/10
        if fl == 0. and self.list:
            return -1
        else:
            return fl
    
    def getLeftIndentEm(self):
        if self.indLeft is None:
            return None
        return round(float(self.indLeft)/20.)/10
    
    def getRightIndentEm(self):
        if self.indRight is None:
            return None
        return round(float(self.indRight)/20.)/10
    
    def getBeforeEm(self):
        if self.before is None:
            return None
        return round(float(self.before)/20.)/10
    
    def getAfterEm(self):
        if self.after is None:
            return None
        return round(float(self.after)/20.)/10
    
    def getCss(self, bold=True, italic=True, defaults=True):
        css = ''
        if self.align is not None:
            if self.align == 'both':
                css += 'text-align:justify;'
            else:
                css += 'text-align: '+self.align+';'
        if self.firstLine is not None or self.list is True:
            css += ('text-indent: %f' % self.getFirstLineValueEm())+'em;'
        elif defaults:
            css += 'text-indent: 0;'
        if self.indLeft is not None:
            css += ('margin-left: %f' % self.getLeftIndentEm())+'em;'
        elif defaults:
            css += 'margin-lef: 0;';
        if self.indRight is not None:
            css += ('margin-right: %f' % self.getRightIndentEm())+'em;'
        elif defaults:
            css += 'margin-right: 0;'
        
        if self._context.opts.replace_bap is False:
            if self.before is not None:
                css += ('margin-top: %f' % self.getBeforeEm())+'em;'
            if self.after is not None:
                css += ('margin-bottom: %f' % self.getAfterEm())+'em;'
                
        if self.shadeColor is not None:
            if self.shadeColor.lower() == 'auto':
                css += 'background-color: black;'
            else:
                css += 'background-color: #%s;' % self.shadeColor
        
        return css
    
    def debug(self):
        print("ParagraphProperties")
        print("      pageBreak", self.pageBreak)
        print("          align", self.align)
        print("      firstLine", self.firstLine)
        print("   firstLine em", self.getFirstLineValueEm())
        print("    left indent", self.indLeft)
        print(" left indent em", self.getLeftIndentEm())
        print("   right indent", self.indRight)
        print("right indent em", self.getRightIndentEm())
        print("        outline", self.outline)
        