__license__ = 'GPL 3'
__copyright__ = '2012 Saulius P.'
__docformat__ = 'restructuredtext en'

'''
Context class to be used in DOCX parsing and
contain required properties.
'''
class DocxContext(object):
    def __init__(self, options):
        '''
        DOCX Input plugin options to be carried
        accross all the conversion process.
        '''
        self.opts = options
        '''
        Current open number of HTML file
        '''
        self.htmlCount = 0
        '''
        A font related dictionary, containing information
        about fonts, used in styles and in the document
        itself.
        '''
        self.fontStyles = {}
        '''
        Written down fonts for embedding.
        '''
        self.fontList = []
        '''
        Image in the first paragraph is considered to be
        a cover, so it is skipped during parsing process
        and not included into output format. Calibre adds
        cover from metadata.
        '''
        self.firstParagraph = True
        '''
        A property to indicate that during parsing the
        page break was found. This is usually a flag
        to open new HTML file.
        '''
        self.renderedPageBreakFound = False
        '''
        A property to indicate that during parsing the
        paragraph-embedded page break was found. 
        This is usually a flag to open new HTML file
        with an option above
        '''
        self.pageBreakFound = False
        '''
        A dictionary of relation id to target mapping.
        Required for images, that are referenced in the
        document.
        '''
        self.relations = {}
        '''
        Dictionary of parsed styles, the key is styleId.
        '''
        self.styles = {}
        '''
        A flag to indicate if any write was called yet.
        Usually if no write was called and page break is found
        in the first paragraph's style, page break is ignored.
        Otherwise it would cause empty HTML file to appear.
        '''
        self.writeCalled = False
        '''
        Footnote count is required to properly number footnotes,
        as Word does not include actual number of the footnote
        anywhere.
        '''
        self.footnoteCount = 0
        '''
        A map between footnote referenceId and its sequence number.
        Used later to generate endnote HTML files (footnotes are
        converted to endnotes for output).
        '''
        self.footnotes = {}
        '''
        A map between footnote referenceId and its anchro for
        back-linking.
        '''
        self.footnoteAnchors = {}
        '''
        Use this property to incorporate Drop Caps (kind of hack
        for conversion to HTML)
        '''
        self.dropCapParagraph = None
        '''
        Written down CSS files.
        '''
        self.cssList = []
        '''
        A dictionary of abstract numbering types, describing
        the formatting of bulletted and numbered lists.
        '''
        self.abstractNums = {}
        '''
        Actual list item mapping to the abstract formatting.
        '''
        self.listNums = {}
        '''
        Ongoing numbering of list items.
        Key is [numId], [level].
        '''
        self.numCounters = {}
