# -*- coding: utf-8 -*-
from datetime import datetime
from PyQt4 import QtCore, QtGui
from calibre.utils.config import JSONConfig
from calibre_plugins.docx_input_plugin.fonts.fontlib import FontLibrary

prefs = JSONConfig('plugins/docx_input_plugin_fontlib')
prefs.defaults['font_library'] = {}
prefs.defaults['last_scan_date'] = '2000-01-01 00:00:00'

try:
    _fromUtf8 = QtCore.QString.fromUtf8
except AttributeError:
    _fromUtf8 = lambda s: s

class Ui_Form(object):
    def setupUi(self, Form):
        Form.setObjectName(_fromUtf8("Form"))
        Form.resize(400, 300)
        self.l = QtGui.QGridLayout(Form)
        self.l.setObjectName(_fromUtf8("l"))
        
        self.cover_label = QtGui.QLabel(Form)
        self.cover_label.setObjectName(_fromUtf8("cover_label"))
        self.l.addWidget(self.cover_label, 0, 0, 1, 1)

        self.opt_first_cover = QtGui.QCheckBox(Form)
        self.opt_first_cover.setObjectName(_fromUtf8("opt_first_cover"))
        self.l.addWidget(self.opt_first_cover, 0, 1, 1, 1)
        
        self.skip_label = QtGui.QLabel(Form)
        self.skip_label.setObjectName(_fromUtf8("skip_label"))
        self.l.addWidget(self.skip_label, 1, 0, 1, 1)

        self.opt_skip_first_pg = QtGui.QCheckBox(Form)
        self.opt_skip_first_pg.setObjectName("opt_skip_first_pg")
        self.l.addWidget(self.opt_skip_first_pg, 1, 1, 1, 1)
        
        self.replace_bap_label = QtGui.QLabel(Form)
        self.replace_bap_label.setObjectName(_fromUtf8("replace_bap_label"))
        self.l.addWidget(self.replace_bap_label, 2, 0, 1, 1)

        self.opt_replace_bap = QtGui.QCheckBox(Form)
        self.opt_replace_bap.setObjectName("opt_replace_bap")
        self.l.addWidget(self.opt_replace_bap, 2, 1, 1, 1)
        
        self.embed_label = QtGui.QLabel(Form)
        self.embed_label.setObjectName(_fromUtf8("embed_label"))
        self.l.addWidget(self.embed_label, 3, 0, 1, 1)

        self.opt_font_embed = QtGui.QComboBox(Form)
        self.opt_font_embed.setObjectName(_fromUtf8("opt_font_embed"))
        self.l.addWidget(self.opt_font_embed, 3, 1, 1, 1)
        
        self.substitute_normal_serif_label = QtGui.QLabel(Form)
        self.substitute_normal_serif_label.setObjectName(_fromUtf8("substitute_normal_serif_label"))
        self.l.addWidget(self.substitute_normal_serif_label, 4, 0, 1, 1)

        self.opt_substitute_normal_serif = QtGui.QCheckBox(Form)
        self.opt_substitute_normal_serif.setObjectName(_fromUtf8("opt_substitute_normal_serif"))
        self.l.addWidget(self.opt_substitute_normal_serif, 4, 1, 1, 1)
        
        self.scan_label = QtGui.QLabel(Form)
        self.scan_label.setObjectName(_fromUtf8("scan_label"))
        if len(prefs['font_library']) > 0:
            self.scan_label.setText(_("Last scan date: %s") % prefs['last_scan_date'])
        else:
            self.scan_label.setText(_("No font scanning performed yet"))
        self.l.addWidget(self.scan_label, 5, 0, 1, 1)
        
        self.scan = QtGui.QPushButton('Scan fonts', Form)
        self.scan.clicked.connect(self._scanFonts)
        self.l.addWidget(self.scan, 5, 1, 1, 1)

        self.retranslateUi(Form)
        QtCore.QMetaObject.connectSlotsByName(Form)
        
    def _scanFonts(self):
        fl = FontLibrary(self.scan_label)
        prefs['font_library'] = fl.buildLibrary()
        prefs['last_scan_date'] = datetime.now().strftime('%Y-%m-%d %H:%M:%S')
        self.scan_label.setText(_("Last scan date: %s") % prefs['last_scan_date'])

    def retranslateUi(self, Form):
        Form.setWindowTitle(_("Form"))
        self.cover_label.setText(_("Use first found image as a cover:"))
        self.skip_label.setText(_("Skip content until first page break:"))
        self.replace_bap_label.setText(_("Replace paragraph spacing with empty lines:"))
        self.embed_label.setText(_("Embed fonts:"))
        self.substitute_normal_serif_label.setText(_("Set \"Normal\" font family to \"Serif\":"))
        
        