# -*- coding: utf-8 -*-

__license__ = 'GPL 3'
__copyright__ = '2012, Saulius P.'
__docformat__ = 'restructuredtext en'

from calibre_plugins.docx_input_plugin.gui.docx_input_ui import Ui_Form
from calibre.gui2.convert import Widget

class PluginWidget(Widget, Ui_Form):

    TITLE = _('DOCX Input')
    HELP = _('Options specific to')+' DOCX '+_('input')
    COMMIT_NAME = 'docx_input_plugin'
    ICON = I('mimetypes/docx.png')

    def __init__(self, parent, get_option, get_help, db=None, book_id=None):
        Widget.__init__(self, parent,
            ['first_cover', 'skip_first_pg', 'replace_bap', 'font_embed', 'substitute_normal_serif'])
        self.db, self.book_id = db, book_id
        
        for x in get_option('font_embed').option.choices:
            self.opt_font_embed.addItem(x)
        
        self.initialize_options(get_option, get_help, db, book_id)

