# -*- coding: utf-8 -*-
# -*- coding: utf-8 -*-
from calibre_plugins.docx_input_plugin.fonts import findsystem

__license__ = 'GPL 3'
__copyright__ = '2012, Saulius P. <saulius@kofmarai.net>'
__docformat__ = 'restructuredtext en'

import struct


class FontLibrary(object):
    
    def __init__(self, qlabel=None):
        self._qlabel = qlabel
    
    def buildLibrary(self):
        lib = {}
        self._setLabel('Searching directories...')
        flist = self.getFontFiles()
        for font in flist:
            self._setLabel(font)
            try:
                family, subfamily = self.getInfo(font)
                if family in lib:
                    lib[family][subfamily] = font
                else:
                    lib[family] = {subfamily : font}
                if subfamily == 'Regular':
                    lib[family]['Default'] = 'Regular'
                elif 'Default' not in lib[family]:
                    if subfamily == 'Book':
                        lib[family]['Default'] = 'Book'
                    elif subfamily == 'Normal':
                        lib[family]['Default'] = 'Normal'
                    elif subfamily == 'Medium':
                        lib[family]['Default'] = 'Medium'
            except:
                print("Font %s could not be added to library." % font)
        print "Font library:\n", lib
        return lib
    
    def getInfo(self, path):
        print 'Font path: ', path
        ff = open(path, "rb")
        f = ff.read();
        ff.close()
        
        if not self.isTTF(f):
            print 'Font is not TTF.'
            return None
        
        fn = self.getFamily(f)
        #(usWeightClass, fsSelection) = self.getModifiers(f)
        
        return fn
    
    def getFontFiles(self):
        l = findsystem.findFonts()
        print "Font file list:\n", l
        return l
    
    def isTTF(self, bytes):
        (uMajorVersion, uMinorVersion) = struct.unpack_from('>HH', bytes)
        #print 'isTTF:: uMajorVersion: ', uMajorVersion, ', uMinorVersion: ', uMinorVersion
        (uTypeStr,) = struct.unpack_from('>4s', bytes)
        return ((uMajorVersion == 1 and uMinorVersion == 0) or (uTypeStr == 'OTTO'))
        
    def getFamily(self, bytes):
        (tname, uCheckSum, uOffset, uLength) = self._getTableDir(bytes, 'name')
        # Read the name table header
        (uFSelector, uNRCount, uStorageOffset) = struct.unpack_from('>HHH', bytes, uOffset)
        #print 'getName:: uFSelector: ', uFSelector, ', uNRCount: ', uNRCount, ' uStorageOffset: ', uStorageOffset
        # Read TTNAME structure
        for i in range(0, uNRCount):
            (uPlatformID, uEncodingID, uLanguageID, uNameID, uStringLength, uStringOffset) = struct.unpack_from('>HHHHHH', bytes, uOffset+6+(i*12))
            #print 'uPlatformID: ',uPlatformID, ', uEncodingID: ',uEncodingID, ', uLanguageID: ',uLanguageID, ', uNameID: ',uNameID, ', uStringLength: ',uStringLength, ', uStringOffset: ', uStringOffset
            if uPlatformID == 1 and uLanguageID == 0:
                if uNameID == 1:
                    (family,) = (struct.unpack_from('>'+str(uStringLength)+'s', bytes, uOffset+uStorageOffset+uStringOffset))
                    print 'Family ID found: "', family, '"'
                    #return name
                elif uNameID == 2:
                    (subfamily,) = (struct.unpack_from('>'+str(uStringLength)+'s', bytes, uOffset+uStorageOffset+uStringOffset))
                    print 'Subfamily ID found: "', subfamily, '"'
        return (family, subfamily.replace(' ', ''))
    
    '''
    def getModifiers(self, bytes):
        (tname, uCheckSum, uOffset, uLength) = self._getTableDir(bytes, 'OS/2')
        (usWeightClass,) = struct.unpack_from('>H', bytes, uOffset+4)
        (fsSelection,)   = struct.unpack_from('>H', bytes, uOffset+62)
        print 'getModifiers:: usWeightClass: ', usWeightClass, ', fsSelection: ', fsSelection, ', &1', fsSelection&1
        return (usWeightClass, fsSelection)
    '''
    
    def _getTableDir(self, bytes, dirName):
        (uNumOfTables,) = struct.unpack_from('>H', bytes, 4)
        # Get the table directory and search for 'name' table information.
        for i in range(0, uNumOfTables):
            (tname, uCheckSum, uOffset, uLength) = struct.unpack_from('>4sLLL', bytes, 12+(i*16))
            #print '_getTableDir:: tname: ', tname, ', uOffset: ', uOffset, ', uLength: ', uLength
            if tname == dirName:
                return (tname, uCheckSum, uOffset, uLength)
        return None
    
    def _setLabel(self, text):
        if self._qlabel is not None:
            self._qlabel.setText(text)
    