from xml.sax import handler

class RelationsParser(handler.ContentHandler):
    
    def __init__(self):
        self._relations = {}

    def startElement(self, name, attrs):
        if name == 'Relationship':
            self._relations[self._getAttributeValue(attrs, 'Id')] = Relation(self._getAttributeValue(attrs, 'Id'), self._getAttributeValue(attrs, 'Target'))
    
    def getRelations(self):
        return self._relations
            
    def _getAttributeValue(self, attrs, attrName):
        for (name, value) in attrs.items():
            #print 'Relationship:: Name, value: ', lname, ', ', value
            if name == attrName:
                return value
        return None

class Relation:
    def __init__(self, relId, relTarget):
        #print 'New Relation: ', relId, ', ', relTarget
        self.id = relId
        self.target = 'word/'+relTarget
        self.used = False
        