from calibre_plugins.docx_input_plugin.structures.lists import AbstractNum,\
    ListLevel, ListStartValue, ListNumberFormatType, ListTextFormat, ListNum,\
    AbstractNumId, NumStyleLink
from calibre_plugins.docx_input_plugin.structures.docx_types import ParagraphFormatting,\
    RichFormatting, Bold, Italic, FontSize, FontCaps, FontColor, StrikeThrough,\
    DoubleStrikeThrough, VerticalAlign, Underline, RichFont
__license__ = 'GPL 3'
__copyright__ = '2012 Saulius P.'
__docformat__ = 'restructuredtext en'

from xml.sax import handler

class NumberingParser(handler.ContentHandler):
    TOP_LEVEL_TAGS = [AbstractNum.TAG, ListNum.TAG]
    TAG_TYPE_MAP = {
                    AbstractNum.TAG: AbstractNum,
                    ListLevel.TAG: ListLevel,
                    ListStartValue.TAG: ListStartValue,
                    ListNumberFormatType.TAG: ListNumberFormatType,
                    ListTextFormat.TAG: ListTextFormat,
                    ListNum.TAG: ListNum,
                    AbstractNumId.TAG: AbstractNumId,
                    ParagraphFormatting.TAG: ParagraphFormatting,
                    RichFormatting.TAG: RichFormatting,
                    Bold.TAG: Bold,
                    Italic.TAG: Italic,
                    FontSize.TAG: FontSize,
                    FontCaps.TAG: FontCaps,
                    FontColor.TAG: FontColor,
                    StrikeThrough.TAG: StrikeThrough,
                    DoubleStrikeThrough.TAG: DoubleStrikeThrough,
                    VerticalAlign.TAG: VerticalAlign,
                    Underline.TAG: Underline,
                    RichFont.TAG: RichFont,
                    NumStyleLink.TAG: NumStyleLink
                    }
    
    def __init__(self, context):
        self._context = context
        self._stack = []
        
    def startElement(self, name, attrs):
        if name in self.TAG_TYPE_MAP:
            #self._indent += 1
            #print(('    '*self._indent)+name)
            if (len(self._stack) > 0) or (len(self._stack) == 0 and name in self.TOP_LEVEL_TAGS):
                element = self.TAG_TYPE_MAP[name](self._context)
                element.preProcessTag(attrs)
                self._stack.append(element)
    
    def endElement(self, name):
        if name in self.TAG_TYPE_MAP:
            #print(('    '*self._indent)+'/'+name)
            #self._indent -= 1
            element = self._stack.pop()
            element.postProcessTag()
            if len(self._stack) > 0:
                self._lastElement().appendElement(element)
    
    def _lastElement(self):
        return self._stack[len(self._stack)-1]
        
    def startDocument(self):
        self._indent = -1
        print('NumberingParser::Starting parsing.')

    def endDocument(self):
        print('NumberingParser::Parsing ended.')