import time
from calibre_plugins.docx_input_plugin.content_handlers.docx2html import Docx2Html
from calibre_plugins.docx_input_plugin.structures.docx_types import Footnote, WordParagraph,\
    WordTextElement, FootnoteReference, RichContainer, RichFormatting, RichStyle,\
    PStyle, Bold, Italic, FontSize, FontColor, FontCaps,\
    ParagraphFormatting, TextAlign, TextIndent, OutlineLevel, Break, PageBreak,\
    Drawing, DrawingAnchor, ABlip, DrawingInline, StrikeThrough,\
    DoubleStrikeThrough, VerticalAlign, RichFont, ParagraphSpacing, Shading,\
    Highlight, Picture, ImageData

class Footnote2Html(Docx2Html):
    
    TOP_LEVEL_TAGS = [Footnote.TAG]
    TAG_TYPE_MAP = {
                    Footnote.TAG: Footnote,
                    WordParagraph.TAG: WordParagraph,
                    WordTextElement.TAG: WordTextElement,
                    FootnoteReference.TAG: FootnoteReference,
                    RichContainer.TAG: RichContainer,
                    RichFormatting.TAG: RichFormatting,
                    RichFont.TAG: RichFont,
                    RichStyle.TAG: RichStyle,
                    PStyle.TAG: PStyle,
                    Bold.TAG: Bold,
                    Italic.TAG: Italic,
                    FontSize.TAG: FontSize,
                    FontColor.TAG: FontColor,
                    FontCaps.TAG: FontCaps,
                    StrikeThrough.TAG: StrikeThrough,
                    DoubleStrikeThrough.TAG: DoubleStrikeThrough,
                    VerticalAlign.TAG: VerticalAlign,
                    Highlight.TAG: Highlight,
                    ParagraphFormatting.TAG: ParagraphFormatting,
                    TextAlign.TAG: TextAlign,
                    TextIndent.TAG: TextIndent,
                    ParagraphSpacing.TAG: ParagraphSpacing,
                    OutlineLevel.TAG: OutlineLevel,
                    Shading.TAG: Shading,
                    Break.TAG: Break,
                    PageBreak.TAG: PageBreak,
                    Drawing.TAG: Drawing,
                    DrawingInline.TAG: DrawingInline,
                    DrawingAnchor.TAG: DrawingAnchor,
                    ABlip.TAG: ABlip,
                    Picture.TAG: Picture,
                    ImageData.TAG: ImageData
                    }
    
    def __init__(self, htmlWriter, context, options):
        Docx2Html.__init__(self, htmlWriter, context, options)
        
    def startDocument(self):
        self._start = time.time()
        self._indent = -1
        print('Starting parsing of the footnotes.')
    
    def endDocument(self):
        print('Parsing of the footnotes ended in %f secs.' % (time.time() - self._start))
    
    def endElement(self, name):
        if len(self._stack) == 1:
            element = self._stack.pop()
            if element.TAG in self.TOP_LEVEL_TAGS:
                if element.seq is not None:
                    self._htmlWriter.open(prefix='ft_', counterOverride=element.seq)
                    self._htmlWriter.write(element.getText())
                    self._htmlWriter.close()
        else:
            Docx2Html.endElement(self, name)
        