__license__ = 'GPL 3'
__copyright__ = '2012 Saulius P.'
__docformat__ = 'restructuredtext en'

from xml.sax import handler
from calibre_plugins.docx_input_plugin.structures.text_properties import FontProperties, ParagraphProperties
from calibre_plugins.docx_input_plugin.structures.docx_types import ContainerElement,\
    IndividualElement, RichFormatting, ParagraphFormatting, PageBreak, TextAlign,\
    TextIndent, OutlineLevel, ParagraphFrame, Bold, Italic, FontSize, FontCaps,\
    FontColor, StrikeThrough, DoubleStrikeThrough, VerticalAlign, Underline,\
    RichFont, ParagraphSpacing, Highlight, Shading, ParagraphNumber, NumberIlvl,\
    NumberId
from calibre_plugins.docx_input_plugin.structures.styles import AbstractStyle,\
    CharacterStyle, ParagraphStyle, TableStyle, NumberingStyle, StyleBasedOn


class Docx2Style(handler.ContentHandler):
    TAG_TYPE_MAP = {
                    AbstractStyle.TAG: AbstractStyle,
                    StyleBasedOn.TAG: StyleBasedOn,
                    RichFormatting.TAG: RichFormatting,
                    RichFont.TAG: RichFont,
                    Bold.TAG: Bold,
                    Italic.TAG: Italic,
                    FontSize.TAG: FontSize,
                    FontCaps.TAG: FontCaps,
                    FontColor.TAG: FontColor,
                    Highlight.TAG: Highlight,
                    StrikeThrough.TAG: StrikeThrough,
                    DoubleStrikeThrough.TAG: DoubleStrikeThrough,
                    VerticalAlign.TAG: VerticalAlign,
                    Underline.TAG: Underline,
                    ParagraphFormatting.TAG: ParagraphFormatting,
                    PageBreak.TAG: PageBreak,
                    TextAlign.TAG: TextAlign,
                    TextIndent.TAG: TextIndent,
                    ParagraphSpacing.TAG: ParagraphSpacing,
                    OutlineLevel.TAG: OutlineLevel,
                    Shading.TAG: Shading,
                    ParagraphFrame.TAG: ParagraphFrame,
                    ParagraphNumber.TAG: ParagraphNumber,
                    NumberIlvl.TAG: NumberIlvl,
                    NumberId.TAG: NumberId
                    }
    
    def __init__(self, context):
        self._lastStyle = None
        self._indent = 0
        #self._styles = {}
        self._context = context
        self._stack = []
    
    def startDocument(self):
        self._indent = -1
        print('Starting parsing of styles.')

    def endDocument(self):
        print('Parsing of styles ended.')
        
    def startElement(self, name, attrs):
        self._indent += 1
        #print(('    '*self._indent)+name)
        
        if name == AbstractStyle.TAG:
            element = self._styleStart(attrs)
            self._stack.append(element)
        elif (name in self.TAG_TYPE_MAP) and (len(self._stack) > 0):
            element = self.TAG_TYPE_MAP[name](self._context)
            element.preProcessTag(attrs)
            self._stack.append(element)

    def endElement(self, name):
        #print(('    '*self._indent)+name)
        
        if name in self.TAG_TYPE_MAP:
            if len(self._stack) > 1:
                element = self._stack.pop()
                element.postProcessTag()
                self._lastElement().appendElement(element)
            elif len(self._stack) == 1:
                element = self._stack.pop()
                element.postProcessTag()
                if element.id in self._context.styles:
                    self._context.styles[element.id].mergeStyle(element)
                else:
                    self._context.styles[element.id] = element
                if element.default is True:
                    if type(element) is ParagraphStyle:
                        self._context.styles["DefaultParagraphStyle"] = self._context.styles[element.id]
        
        self._indent -= 1
        
    def _styleStart(self, attrs):
        sType = 'character'
        sId   = 'Normal'
        sDefault = False
        for (name, value) in attrs.items():
            if name == 'w:type':
                sType = value
            elif name == 'w:styleId':
                sId = value
            elif name == 'w:default' and value == '1':
                sDefault = True
        if sType == 'character':
            newStyle = CharacterStyle(sId, self._context)
        elif sType == 'paragraph':
            newStyle = ParagraphStyle(sId, self._context)
        elif sType == 'table':
            newStyle = TableStyle(sId, self._context)
        elif sType == 'numbering':
            newStyle = NumberingStyle(sId, self._context)
        else:
            raise Exception(_("Style type %s not supported" % sType))
        
        newStyle.default = sDefault
        
        return newStyle
    
    def _styleEnd(self):
        #print("Docx2Style::_styleEnd:")
        self._lastStyle.debugStyle()
        self._context.styles[self._lastStyle.id] = self._lastStyle
        self._lastStyle = None
    
    def _lastElement(self):
        return self._stack[len(self._stack)-1]
        

