__license__ = 'GPL 3'
__copyright__ = '2012 Saulius P.'
__docformat__ = 'restructuredtext en'

import time
from xml.sax import handler
from calibre_plugins.docx_input_plugin.structures.docx_types import WordParagraph,\
    WordTextElement, FootnoteReference, RichContainer, RichFormatting, RichStyle,\
    PStyle, Bold, Italic, FontSize, FontColor, FontCaps,\
    ParagraphFormatting, TextAlign, TextIndent, OutlineLevel, Break, PageBreak,\
    Drawing, DrawingAnchor, ABlip, DrawingInline, Table, TableRow, TableCell, LastRenderedPageBreak,\
    ParagraphFrame, StrikeThrough, DoubleStrikeThrough, VerticalAlign, Underline,\
    PositionH, PosOffset, RichFont, ParagraphNumber, NumberIlvl, NumberId,\
    ParagraphSpacing, Highlight, Shading, Picture, ImageData

class Docx2Html(handler.ContentHandler):
    TOP_LEVEL_TAGS = [WordParagraph.TAG, Table.TAG]
    TAG_TYPE_MAP = {
                    WordParagraph.TAG: WordParagraph,
                    WordTextElement.TAG: WordTextElement,
                    FootnoteReference.TAG: FootnoteReference,
                    RichContainer.TAG: RichContainer,
                    RichFormatting.TAG: RichFormatting,
                    RichFont.TAG: RichFont,
                    RichStyle.TAG: RichStyle,
                    PStyle.TAG: PStyle,
                    Bold.TAG: Bold,
                    Italic.TAG: Italic,
                    Underline.TAG: Underline,
                    FontSize.TAG: FontSize,
                    FontColor.TAG: FontColor,
                    FontCaps.TAG: FontCaps,
                    StrikeThrough.TAG: StrikeThrough,
                    DoubleStrikeThrough.TAG: DoubleStrikeThrough,
                    VerticalAlign.TAG: VerticalAlign,
                    Highlight.TAG: Highlight,
                    ParagraphFormatting.TAG: ParagraphFormatting,
                    TextAlign.TAG: TextAlign,
                    TextIndent.TAG: TextIndent,
                    ParagraphSpacing.TAG: ParagraphSpacing,
                    OutlineLevel.TAG: OutlineLevel,
                    Shading.TAG: Shading,
                    Break.TAG: Break,
                    PageBreak.TAG: PageBreak,
                    LastRenderedPageBreak.TAG: LastRenderedPageBreak,
                    ParagraphFrame.TAG: ParagraphFrame,
                    Drawing.TAG: Drawing,
                    DrawingInline.TAG: DrawingInline,
                    DrawingAnchor.TAG: DrawingAnchor,
                    PositionH.TAG: PositionH,
                    PosOffset.TAG: PosOffset,
                    ABlip.TAG: ABlip,
                    Picture.TAG: Picture,
                    ImageData.TAG: ImageData,
                    Table.TAG: Table,
                    TableRow.TAG: TableRow,
                    TableCell.TAG: TableCell,
                    ParagraphNumber.TAG: ParagraphNumber,
                    NumberIlvl.TAG: NumberIlvl,
                    NumberId.TAG: NumberId
                    }
    
    def __init__(self, htmlWriter, context, options):
        self._indent = -1
        self._htmlWriter = htmlWriter
        self._context = context
        self._opts = options
        self._stack = []
        self._start = None
        
    def startDocument(self):
        self._start = time.time()
        self._indent = -1
        print('Starting parsing of the document.')
        self._htmlWriter.open()
    
    def endDocument(self):
        self._htmlWriter.close()
        print('Parsing of the document ended in %f secs.' % (time.time() - self._start))
    
    def startElement(self, name, attrs):
        if name in self.TAG_TYPE_MAP:
            self._indent += 1
            if (len(self._stack) > 0) or (len(self._stack) == 0 and name in self.TOP_LEVEL_TAGS):
                element = self.TAG_TYPE_MAP[name](self._context)
                element.preProcessTag(attrs)
                self._stack.append(element)
        #print('Docx2Html2::startElement::END::%s::Stack' % name, self._stack)
    
    def endElement(self, name):
        if name in self.TAG_TYPE_MAP:
            if len(self._stack) > 1:
                element = self._stack.pop()
                element.postProcessTag()
                self._lastElement().appendElement(element)
            elif len(self._stack) == 1:
                element = self._stack.pop()
                element.postProcessTag()
                if element.TAG in self.TOP_LEVEL_TAGS:
                    if element.TAG == WordParagraph.TAG:
                        if element.dropCap is not True:
                            if ((element.getStyle() is not None and element.getStyle().paragraphProperties.pageBreak is True) \
                                or self._context.pageBreakFound) and self._context.renderedPageBreakFound:
                                self._htmlWriter.open()
                                self._context.pageBreakFound = False
                                self._context.renderedPageBreakFound = False
                        else:
                            self._context.dropCapParagraph = element
                            self._indent -= 1
                            return
                
                self._htmlWriter.write(element.getText())
                ######## DEBUG #########
                #element.debug()
                ''''''''''''''''''''''''
                self._context.writeCalled = True
                #if self._context.pageBreakFound is True and self._context.renderedPageBreakFound is True:
                #    self._htmlWriter.open()
                #    self._context.renderedPageBreakFound = False
                #    self._context.pageBreakFound = False
            self._indent -= 1
        
    def characters(self, content):
        #print('Docx2Html2::characters::START')
        if len(self._stack) > 0:
            #print('Docx2Html2::characters: %s, %d' % (self._lastElement().TAG, self._lastElement().CHARACTERS))
            if self._lastElement().CHARACTERS:
                self._lastElement().processCharacters(content)
        
    def _lastElement(self):
        return self._stack[len(self._stack)-1]
    
        