<?php
	/*
		Name:		 Calibre PHP webserver
		license:	 GPL v3
		copyright:	 2010, Charles Haley
	                 http://charles.haleys.org
	*/

	require_once 'config.php';
	require_once 'utilities.php';
	require_once 'smarty.php';
	
	/*
	 * This is the disconnect action.
	 * Destroys the session
	 *
	 */

	// Destroy all session variables
	$_SESSION = array();

	// Erase session cookie
	if (ini_get("session.use_cookies")) {
		$params = session_get_cookie_params();
		setcookie(session_name(), '', time() - 42000,
			$params["path"], $params["domain"],
			$params["secure"], $params["httponly"]
		);
	}

	// finally destroys session
	session_destroy();
	
	/*
	 * Send back to login page
	 */
	
	$smarty->assign('message', "You have been disconnected");
	$smarty->display('login.tpl');	

?>