#!/bin/bash
infile=$1
outfile="RS-Deutsch-Englisch (De-En).txt"
if [ -z "$1" ] ; then
    echo "Missing infile!"
    exit 1
fi
if [ ! -f "$1" ] ; then
    echo "Infile ($1) not found!"
    exit 1
fi
if [ -f "${outfile}" ] ; then
    echo "Outfile (${outfile}) already exists!"
    echo "Press Ctrl-C within 5 seconds to stop working!"
    sleep 5
fi
echo "Start processing..."
sed	-e "s/\o15//g" \
	-e "/^$/d" \
	-e "s/\&#257;/ā/g" \
	-e "s/\&#268;/Č/g" \
	-e "s/\&#269;/č/g" \
	-e "s/\&#283;/ě/g" \
	-e "s/\&#305;/ı/g" \
	-e "s/\&#322;/ł/g" \
	-e "s/\&#324;/ń/g" \
	-e "s/\&#333;/ō/g" \
	-e "s/\&#345;/ř/g" \
	-e "s/\&#346;/Ś/g" \
	-e "s/\&#347;/ś/g" \
	-e "s/\&#351;/ş/g" \
	-e "s/\&#379;/Ż/g" \
	-e "s/\&#380;/ż/g" \
	-e "s/\&#711;/ˇ/g" \
	-e "s/\&#803;//g" \
	-e "s/\&#916;/Δ/g" \
	-e "s/\&#934;/Φ/g" \
	-e "s/\&#937;/Ω/g" \
	-e "s/\&#945;/α/g" \
	-e "s/\&#946;/β/g" \
	-e "s/\&#956;/μ/g" \
	-e "s/\&#960;/π/g" \
	-e "s/\&#963;/σ/g" \
	-e "s/\&#966;/φ/g" \
	-e "s/\&#969;/ω/g" \
	-e "s/\&#8211;/–/g" \
	-e "s/\&#8217;/’/g" \
	-e "s/\&#8486;/Ω/g" \
	-e "s/\&#8531;/⅓/g" \
	-e "s/ {.}//g" \
	-e "s/ {..}//g" \
	-e "s/ \[[0-9]*\]//g" \
	-e "/^#.*/d" \
	-e "s/ \[+[^ ]*\]//g" \
	-e "s/ \[acc.\]//g" \
	-e "s/ \[class.\]//g" \
	-e "s/ \[comp.\]//g" \
	-e "s/ \[dat.[^]]*\]//g" \
	-e "s/ \[den.\]//g" \
	-e "s/ \[desp.\]//g" \
	-e "s/ \[et fig.\]//g" \
	-e "s/ \[fig.\]//g" \
	-e "s/ \[gen.[^]]*\]//g" \
	-e "s/ \[iireg.\]//g" \
	-e "s/ \[Imp., gr. Fremdw.\]//g" \
	-e "s/ \[impers.\]//g" \
	-e "s/ \[inf.[^]]*\]//g" \
	-e "s/ \[indekl.\]//g" \
	-e "s/ \[intrans.\]//g" \
	-e "s/ \[irreg.\]//g" \
	-e "s/ \[isol. Imp.\]//g" \
	-e "s/ \[mdv.\]//g" \
	-e "s/ \[met.\]//g" \
	-e "s/ \[pej.\]//g" \
	-e "s/ \[rec.\]//g" \
	-e "s/ \[Sing[^]]*\]//g" \
	-e "s/ \[v. orth.\]//g" \
	-e "s/ \[vir\]//g" \
	-e "s/ \[[^]]*+[^#]*\]//g" \
	-e "s/ <\([^>]*\)>/, Abk.: \1/g" \
	-e "s/\o11noun/\o11Substantiv/g" \
	-e "s/\o11suffix/\o11Suffix/g" \
	-e "s/\o11prefix/\o11Prefix/g" \
	-e "s/\o11verb/\o11Verb/g" \
	-e "s/\o11\[verb\]/\o11Verb/g" \
	-e "s/\o11adj/\o11Adjektiv/g" \
	-e "s/\o11pron/\o11Pronomen/g" \
	-e "s/\o11prep/\o11Präposition/g" \
	-e "s/\o11adv/\o11Adverb/g" \
	-e "s/\o11Adv\./\o11Adverb/g" \
	-e "s/\o11conj/\o11Konjunktion/g" \
	-e "s/\o11past-p/\o11/g" \
	-e "s/\o11pres-p/\o11/g" \
	-e "s/\o11interj/\o11/g" \
	-e "s/\o11numer/\o11/g" \
	-e "s/\o11Redew\./\o11/g" \
	-e "s/ past-p//g" \
	-e "s/\([^\o11]*\)\o11\([^\o11\]*\)\o11\([^\o11]*\)/\1\ \ \ <i>\3<\/i>,\ \2/" \
	-e "s/<i><\/i>,\ //g" \
	"${infile}" > "${outfile}"
echo "Start converting..."
wine ./MyDicConverter/converter.exe "${outfile}" ./MyDicConverter/locales/de
echo "The End..."