#!/bin/sh

ATTEMPTS=30
LIST_URL="http://192.0.0.0/books/filelist.php";
PING_IP="192.0.0.0"

#uncomment the next line to always download files in the list (i.e. ignore existing downloaded file, save with unique name)
#ALWAYS_DL=1

# wait for wifi network to come online; give up after $ATTEMPTS tries
tries=1
while ! ping -c 1 -q $PING_IP; do 
   if [ "$tries" -gt "$ATTEMPTS" ] ; then 
     timestamp=`date`
     echo "sync: aborted after $ATTEMPTS connection attempts ($timestamp)" >>/mnt/onboard/sync.log
     break; 
   fi
   sleep 2
   tries=$(( $tries + 1 ))
done

   
successes=0
LIST=`/usr/bin/wget -q -O - $LIST_URL`
IFS=$'\n'  # make the for loop break up the list on newlines

for url in $LIST; do
  filename=`echo $url|sed -e 's|.*/||g'`
  if [ $ALWAYS_DL ] ; then
    timestamp=`date +%Y%m%d-%k%M%S`
    if /usr/bin/wget "$url" -O "/mnt/onboard/$timestamp-$filename" >>/mnt/onboard/wget.log 2>&1 ; then
      successes=$(( $successes + 1 ))                                                                                                                 
      echo "Downloaded (forced) $url to $timestamp-$filename" >>/mnt/onboard/sync.log
    else
      timestamp=`date`                                                                                                                                
      echo "Failed to force download $url ($timestamp)" >>/mnt/onboard/sync.log                                                                
    fi
  else
    if /usr/bin/wget "$url" -O "/mnt/onboard/$filename" >>/mnt/onboard/wget.log 2>&1 ; then 
      successes=$(( $successes + 1 ))
      echo "Downloaded $url" >>/mnt/onboard/sync.log
    else
      timestamp=`date`
      echo "Failed to download $url (file exists? $timestamp)" >>/mnt/onboard/sync.log
    fi
  fi
done

if [ "$successes" -gt "0" ] ; then 
  timestamp=`date`
  echo "Downloaded $successes files ($timestamp)" >>/mnt/onboard/sync.log
  nohup /mnt/onboard/reindex.sh &
fi



