#!/perl/bin/perl -w
#
# Adapted by Nick Rapallo (January 2008)
#
# Example code taken directly from "SBPubX.doc" (installed by the eBook Publisher software).
# Currently "hard-coded" input file and assumes existence of 'Crsto.htm' and 'MonteCristo.opf';
# the latter being created after executing the perl script 'buildIMP.pl'
#
################################################################
# Main Program
#
package main;
use Win32::OLE qw(EVENTS);
Win32::OLE->Initialize(Win32::OLE::COINIT_APARTMENTTHREADED);

# get the interfaces, complain and quit if we cannot
#
$project = Win32::OLE->new("SBPublisher.Project") or
	die "Unable to get IProject interface\n";

$builder = Win32::OLE->new("SBPublisher.Builder") or
	die "Unable to get IBuilder interface\n";

# Setup the event handling.
#
Win32::OLE->WithEvents($builder, 'EventHandlers');

 
# Load our project and perform the validation
#
$project->Load("MonteCristo.opf");
if (Win32::OLE->LastError() != 0) {
	die "Unable to load project.\n";
}

# Load our OEBFF and perform the validation
#
#$project->LoadFromOEBFF("MonteCristo.oeb");
#if (Win32::OLE->LastError() != 0) {
#	die "Unable to load OEBFF.\n";
#}

$builder->ValidateManifest($project);
if (Win32::OLE->LastError() != 0) {
	die "Unable to validate project manifest\n";
}

print "\nDone!\n";
Win32::OLE->Uninitialize();

###################################################################
# Event Handlers
#
package EventHandlers;

sub OnBuildStart()
{
	my ($project, @args) = @_;
	print "Beginning validation...\n";
}

sub OnSourceStart()
{
	my ($builder, $filename, @args) = @_;
	print "Parsing $filename...\n";
}

sub OnError()
{
	# Get the arguments
	my ($builder,
		$filename, 
		$msg, 
		$line, 
		$col, 
		$severity, 
		@args) = @_;

	my @severities = ("NOTE", "FATAL ERROR", "ERROR", "WARNING");

	# Print out the error message but don't print out any NOTE
	# feedback.
	if ($severity != 0)
	{
		printf(" %-7s: Line %3d, Col %3d of %s\n",
			$severities[$severity],
			$line,
			$col,
			$filename);

		print "\t$msg\n";
	}
}
