#!/perl/bin/perl -w
#
# Adapted by Nick Rapallo (January 2008)
#
# Example code taken directly from "SBPubX.doc" (installed by the eBook Publisher software).
# Currently "hard-coded" input file and assume existence of 'Crsto.htm' and 'MonteCristo.opf';
# the latter being created after executing the perl script 'buildIMP.pl'
#
use Win32::OLE;
Win32::OLE->Initialize(Win32::OLE::COINIT_APARTMENTTHREADED);

# get the interface, complain and quit if we cannot
#
$project = Win32::OLE->new("SBPublisher.Project") or
	die "Unable to get IProject interface\n";

# Load the OPF File
#
$project->Load("MonteCristo.opf");
if (Win32::OLE->LastError() != 0) {
	die "Unable to load project.\n";
}

# Load the OEBFF File
#
#$project->LoadFromOEBFF("MonteCristo.oeb");
#if (Win32::OLE->LastError() != 0) {
#	die "Unable to load OEBFF.\n";
#}

# Get the desired information from the OEBFF
#
printf("%-20s : %s\n", "Title", $project->{BookTitle});
printf("%-20s : %s\n", "BookFileName", $project->{BookFileName});
printf("%-20s : %s\n", "Author", $project->{AuthorFirstName});
printf("%-20s : %s\n", "AuthorFileAs", $project->{AuthorFileAs});
printf("%-20s : %s\n", "Category", $project->{Category});
printf("%-20s : %s\n", "ISBN", $project->{ISBN});
printf("%-20s : %s\n", "Unique ID", $project->{BookID});
printf("%-20s : %s (%s)\n", "Publisher", $project->{Publisher},	$project->{Imprint});
printf("%-20s : %s\n", "Date Published", $project->{PublishDate});
printf("%-20s : %s\n", "BISAC", $project->{BISAC});
printf("%-20s : %s\n", "BuildTarget", $project->{BuildTarget});
printf("%-20s : %s\n", "ColorCover", $project->{ColorCover});
printf("%-20s : %d\n", "Compress", $project->{Compress});
printf("%-20s : %d\n", "Encrypt", $project->{Encrypt});
printf("%-20s : %d\n", "KeepAnchors", $project->{KeepAnchors});
printf("%-20s : %s\n", "Keywords", $project->{Keywords});
printf("%-20s : %s\n", "Language", $project->{Language});
printf("%-20s : %s\n", "ProjectFile", $project->{ProjectFile});
printf("%-20s : %d\n", "ProjectFormat", $project->{ProjectFormat});
printf("%-20s : %d\n", "RequireISBN", $project->{RequireISBN});
printf("%-20s : %s\n", "TitleFileAS", $project->{TitleFileAS});
printf("%-20s : %d\n", "UnderlineLinks", $project->{UnderlineLinks});
printf("%-20s : %d\n", "Zoom", $project->{Zoom});

Win32::OLE->Uninitialize();
