#include "StdAfx.h"
#include "output.h"


output::output(const char* name)
{
	file_ = fopen(name, "wb");
}


output::~output(void)
{
	close();
}

void output::close()
{
	if(file_)
	{
		fclose(file_);
		file_ = 0;
	}
}

void output::writeByte(unsigned char c)
{
	fwrite(&c, 1, 1, file_);
}

void output::writeShort(unsigned short s)
{
	writeByte( (s>>8) );
	writeByte( s&0xFF );
}
void output::writeInt(unsigned int i)
{
	writeShort( i >> 16 );
	writeShort( i & 0xFFFF );
}

void output::writeArray(const char* data, int len)
{
	fwrite( data, len, 1, file_);
}