#include "StdAfx.h"
#include "input.h"


input::input(char* data, long size): size_(size), pos_(0)
{
	data_.resize(size);
	std::copy(data, data+size, data_.begin());

}

input::input(const char* fname): size_(0), pos_(0)
{
	FILE* file = fopen(fname, "rb");
	if(file) {
		fseek(file, 0, SEEK_END);
		size_ = ftell(file);
		fseek(file, 0, SEEK_SET);
		data_.resize(size_);
		fread(&data_[0], size_, 1, file);
		fclose(file);
	} else
	{
		throw "file not found";
	}
}


input::~input()
{
	close();
}

unsigned char input::readByte()
{
	unsigned char b = (unsigned char)data_[pos_++] ;
	return b;
}
unsigned short input::readShort()
{
	unsigned short s = readByte() << 8;
	s |= readByte();
	return s;

}
unsigned int input::readInt()
{
	unsigned int i = readShort() << 16;
	i |= readShort();
	return i;
}
void input::close()
{
	data_.clear();
	pos_=0;
	size_=0;
}

long input::size() const 
{
	return size_;
}
long input::pos() const
{
	return pos_;
}

int input::readArray(char* array_, int len)
{
	if(!len) return 0;
	memcpy(array_, &data_[pos_], len);
	pos_ += len;
	return len;
}

void input::skip(long off)
{
	pos_ += off;
	if(pos_ > size_)
		pos_ = size_;
}

