#pragma once

#include <vector>

class cpinfo;
class attrinfo;
class fldinfo;
class methinfo;

class clazz
{
public:
	clazz(const char* name);
	~clazz(void);
	void load(const char* name);
	void save(const char* name = 0);

	cpinfo* getcpinfo(unsigned short idx);
	unsigned short addcpinfo(cpinfo* info);

	void removelocalvars();
	void renamefields();
private:
	std::wstring demangle(std::wstring desc);
	std::wstring rename(std::wstring name, std::wstring desc);
private:
	char name_[255];

	unsigned int magic_;
	unsigned short major_, minor_;
	//unsigned short cpcount_;
	std::vector<cpinfo*> cpool_;
	unsigned short accessflag_;
	unsigned short thiscls_;
	unsigned short supercls_;

	std::vector<unsigned short> interfaces_;
	std::vector<fldinfo*> fields_;
	std::vector<methinfo*> methods_;
	std::vector<attrinfo*> attrs_;

};

