#pragma once

#include <vector>

const wchar_t ATTR_Code[]                = L"Code";
const wchar_t ATTR_ConstantValue[]       = L"ConstantValue";
const wchar_t ATTR_Exceptions[]          = L"Exceptions";
const wchar_t ATTR_LineNumberTable[]     = L"LineNumberTable";
const wchar_t ATTR_SourceFile[]          = L"SourceFile";
const wchar_t ATTR_LocalVariableTable[]  = L"LocalVariableTable";
const wchar_t ATTR_InnerClasses[]        = L"InnerClasses";
const wchar_t ATTR_Synthetic[]           = L"Synthetic";

class input;
class output;
class clazz;
class excinfo;
class linenuminfo;
class localvarinfo;

class attrinfo
{
public:
	virtual ~attrinfo() {}
	static attrinfo* load(input& i, clazz& owner);
	virtual void loadinfo(input& i) = 0;
	void saveinfo(output& o);
	virtual void savedetail(output& o) = 0;
	virtual unsigned int length() const = 0;

protected:
	attrinfo(clazz& owner, unsigned short nat, unsigned int len);
protected:	
	static const int CONSTANT_FIELD_SIZE = 6;
	clazz& owner_;
	unsigned short attrnat_;
	unsigned int   attrlen_;
};

class unkattrinfo: public attrinfo
{	
public:
	~unkattrinfo();
	unkattrinfo(clazz& owner, unsigned short nat, unsigned int len): attrinfo(owner, nat, len), data_(0) {}
	void loadinfo(input& i);
	void savedetail(output& o);
	unsigned int length() const;
protected:
	char*    data_;
};

class codeattrinfo: public attrinfo
{
public:
	~codeattrinfo();
	codeattrinfo(clazz& owner, unsigned short nat, unsigned int len): attrinfo(owner, nat, len), code_(0) {}
	void loadinfo(input& i);
	void savedetail(output& o);
	unsigned int length() const;
	void removelocalvars();
private:
	static const int CONSTANT_FIELD_SIZE = 12;
	unsigned short maxstack_;	
	unsigned short maxlcls_;
	unsigned int   codelen_;
	char*          code_;
	std::vector<excinfo*> exctable_;
	std::vector<attrinfo*> attrs_;
};

class constvalinfo: public attrinfo 
{
public:
	constvalinfo(clazz& owner, unsigned short nat, unsigned int len): attrinfo(owner, nat, len) {}
	void loadinfo(input& i);
	void savedetail(output& o);
	unsigned int length() const { return sizeof(unsigned short); }
private:
	unsigned short index_;
};

class excattrinfo: public attrinfo
{
public:
	//~excattrinfo(); 
	excattrinfo(clazz& owner, unsigned short nat, unsigned int len): attrinfo(owner, nat, len) {}
	void loadinfo(input& i);
	void savedetail(output& o);
	unsigned int length() const;
private:
	std::vector<unsigned short> exctable_; 
};

class linenumaterinfo: public attrinfo
{
public:
	linenumaterinfo(clazz& owner, unsigned short nat, unsigned int len): attrinfo(owner, nat, len) {}
	~linenumaterinfo();
	void loadinfo(input& i);
	void savedetail(output& o);
	unsigned int length() const;
private:
	std::vector<linenuminfo*> linenumtable_; 
};

class localvartableinfo: public attrinfo
{
public:
	localvartableinfo(clazz& owner, unsigned short nat, unsigned int len): attrinfo(owner, nat, len) {}
	~localvartableinfo();
	void loadinfo(input& i);
	void savedetail(output& o);
	unsigned int length() const;
private:
	std::vector<localvarinfo*> localvartable_; 
};