#include "StdAfx.h"

#include <string>

#include "attrinfo.h"
#include "input.h"
#include "output.h"
#include "clazz.h"
#include "cpinfo.h"
#include "excinfo.h"
#include "linenuminfo.h"

attrinfo::attrinfo(clazz& owner, unsigned short nat, unsigned int len): owner_(owner), attrnat_(nat), attrlen_(len)
{
}

attrinfo* attrinfo::load(input& i, clazz& owner)
{
	attrinfo* ai = 0;
	unsigned short attrnat = i.readShort();
	unsigned int   attrlen = i.readInt();

	cpinfo* info = owner.getcpinfo(attrnat);
	if(info && info->tag() == CONSTANT_Utf8) 
	{
		
		utf8cpinfo* utf = dynamic_cast<utf8cpinfo*>(info);
		std::wstring name = utf->get();
		
		if( name.compare(ATTR_Code) == 0)
		{
			ai = new codeattrinfo(owner, attrnat, attrlen);
		} 
		else if ( name.compare(ATTR_ConstantValue) == 0)
		{
			ai = new constvalinfo(owner, attrnat, attrlen);
		}
		else if ( name.compare(ATTR_Exceptions) == 0)
		{
			ai = new excattrinfo(owner, attrnat, attrlen);
		}
		else if ( name.compare(ATTR_LineNumberTable) == 0)
		{
			ai = new linenumaterinfo(owner, attrnat, attrlen);
		}
		else if ( name.compare(ATTR_LocalVariableTable) == 0)
		{
			ai = new localvartableinfo(owner, attrnat, attrlen);
		}
		else
		{
			ai = new unkattrinfo(owner, attrnat, attrlen);
		}

	}
	else
	{
		throw "inconsistent ref to constant pool";
	}
	ai->loadinfo(i);
	return ai;
}


void attrinfo::saveinfo(output& o)
{
	o.writeShort(attrnat_);
	o.writeInt( length() );
	savedetail(o);
}

//--------------------------------------------------
unkattrinfo::~unkattrinfo(void)
{
	if(data_) 
	{
		delete [] data_;
	}
}

void unkattrinfo::loadinfo(input& i)
{
	if(attrlen_) {
		data_ = new char[attrlen_];
		i.readArray(data_, attrlen_);
	}
}

unsigned int unkattrinfo::length() const
{
	return attrlen_;
}

void unkattrinfo::savedetail(output& o)
{
	o.writeArray(data_, attrlen_);
}

//--------------------------------------------------
codeattrinfo::~codeattrinfo()
{
	if(code_)
	{
		delete[] code_;
	}

	while(!exctable_.empty()) delete exctable_.back(), exctable_.pop_back();
	while(!attrs_.empty()) delete attrs_.back(), attrs_.pop_back();

}
void codeattrinfo::loadinfo(input& i)
{
	maxstack_ = i.readShort();
	maxlcls_  = i.readShort();
	codelen_  = i.readInt();
	code_     = new char[codelen_];
	i.readArray(code_, codelen_);
	unsigned short count;

	count = i.readShort();
	for(unsigned short i_=0; i_<count; ++i_)
	{
		excinfo* info = new excinfo();
		info->loadinfo(i);
		exctable_.push_back(info);
	}

	count = i.readShort();
	for(unsigned short i_=0; i_<count; ++i_)
	{
		attrinfo* info = attrinfo::load(i, owner_);
		attrs_.push_back(info);
	}

}

unsigned int codeattrinfo::length() const 
{
	unsigned int len = CONSTANT_FIELD_SIZE + codelen_ + exctable_.size() * excinfo::CONSTANT_FIELD_SIZE;
	unsigned short count = attrs_.size();
	for(unsigned short i=0; i<count; i++)
	{
		len += attrinfo::CONSTANT_FIELD_SIZE + attrs_.at(i)->length();
	}
	return len;
}

void codeattrinfo::savedetail(output& o)
{
	o.writeShort(maxstack_);
	o.writeShort(maxlcls_);
	o.writeInt(codelen_);
	o.writeArray(code_, codelen_);
	unsigned short count;
	
	count = exctable_.size();
	o.writeShort(count);
	for(unsigned short i=0; i<count; ++i)
	{
		excinfo* info = exctable_.at(i);
		info->saveinfo(o);
	}

	count = attrs_.size();
	o.writeShort(count);
	for(unsigned short i=0; i<count; ++i)
	{
		attrinfo* info = attrs_.at(i);
		info->saveinfo(o);
	}
}

void codeattrinfo::removelocalvars()
{
	unsigned short i=0;
	while( i<attrs_.size())
	{
		localvartableinfo* info = dynamic_cast<localvartableinfo*> (attrs_.at(i));
		if(info)
		{
			attrs_.erase(attrs_.begin() + i);
			delete info;
		}
		else
			++i;
	}
}

//-------------------------------------------------------

void constvalinfo::loadinfo(input& i)
{
	index_ = i.readShort();
}
void constvalinfo::savedetail(output& o)
{
	o.writeShort(index_);
}

//-------------------------------------------------------

void excattrinfo::loadinfo(input& i)
{
	unsigned short count = i.readShort();
	for(unsigned short i_=0; i_<count; ++i_)
	{
		unsigned short exc = i.readShort();
		exctable_.push_back(exc);
	}
}
void excattrinfo::savedetail(output& o)
{
	unsigned short count = exctable_.size();
	o.writeShort( count );
	for(unsigned short i=0; i<count; ++i) 
	{
		o.writeShort( exctable_.at(i) );
	}
}

unsigned int excattrinfo::length() const
{
	unsigned int len = sizeof(unsigned short) + exctable_.size() * sizeof(unsigned short);
	return len;
}
//-------------------------------------------------------

linenumaterinfo::~linenumaterinfo()
{
	while(!linenumtable_.empty()) delete linenumtable_.back(), linenumtable_.pop_back();
}
void linenumaterinfo::loadinfo(input& i)
{
	unsigned short count = i.readShort();
	for(unsigned short i_=0; i_<count; ++i_)
	{
		linenuminfo* info = new linenuminfo();
		info->loadinfo(i);
		linenumtable_.push_back(info);
	}
}
void linenumaterinfo::savedetail(output& o)
{
	unsigned short count = linenumtable_.size();
	o.writeShort(count);
	for(unsigned short i_=0; i_<count; ++i_)
	{
		linenuminfo* info = linenumtable_.at(i_);
		info->saveinfo(o);
	}
}
unsigned int linenumaterinfo::length() const
{
	unsigned int len = sizeof(unsigned short) + linenumtable_.size() * linenuminfo::CONSTANT_FIELD_SIZE;
	return len;
}

//-------------------------------------------------------

localvartableinfo::~localvartableinfo()
{
	while(!localvartable_.empty()) delete localvartable_.back(), localvartable_.pop_back();
}
void localvartableinfo::loadinfo(input& i)
{
	unsigned short count = i.readShort();
	for(unsigned short i_=0; i_<count; ++i_)
	{
		localvarinfo* info = new localvarinfo();
		info->loadinfo(i);
		localvartable_.push_back(info);
	}
}
void localvartableinfo::savedetail(output& o)
{
	unsigned short count = localvartable_.size();
	o.writeShort(count);
	for(unsigned short i_=0; i_<count; ++i_)
	{
		localvarinfo* info = localvartable_.at(i_);
		info->saveinfo(o);
	}
}
unsigned int localvartableinfo::length() const
{
	unsigned int len = sizeof(unsigned short) + localvartable_.size() * localvarinfo::CONSTANT_FIELD_SIZE;
	return len;
}

//-------------------------------------------------------


