#pragma once

#include <string>

class input;
class output;
//------------------------------------------

#define CONSTANT_Utf8                1
#define CONSTANT_Integer             3
#define CONSTANT_Float               4
#define CONSTANT_Long                5
#define CONSTANT_Double              6
#define CONSTANT_Class               7
#define CONSTANT_String              8
#define CONSTANT_Fieldref            9
#define CONSTANT_Methodref           10
#define CONSTANT_InterfaceMethodref  11
#define CONSTANT_NameAndType         12

//------------------------------------------
class cpinfo
{
public:
	virtual ~cpinfo(void);
	static cpinfo* load(input& i);
	unsigned char tag() const { return tag_; }
	virtual void readinfo(input& i) = 0;
	void writeinfo(output& o);
	virtual void writedetail(output& o) = 0;
protected:
	cpinfo(unsigned char tag);
private:
	unsigned char tag_;
};

class utf8cpinfo: public cpinfo
{
public:
	~utf8cpinfo();
	utf8cpinfo();
	utf8cpinfo(std::wstring name);
	void readinfo(input& i);
	void writedetail(output& o);
	std::wstring get() const;
	void set(const std::wstring& val);
private:
	void clear();
private:
	char* data_;
	int len_;
};
//-------------------------------------------------------
class intcpinfo: public cpinfo
{
public:
	intcpinfo(): cpinfo(CONSTANT_Integer) {}
	void readinfo(input& i);
	void writedetail(output& o);
	unsigned int get() const { return val_; }
private:
	unsigned int val_;
};
//-------------------------------------------------------
class floatcpinfo: public cpinfo
{
public:
	floatcpinfo(): cpinfo(CONSTANT_Float) {}
	void readinfo(input& i);
	void writedetail(output& o);
	float get() const { return val_; }
private:
	float val_;
};
//-------------------------------------------------------
class longcpinfo: public cpinfo
{
public:
	longcpinfo(): cpinfo(CONSTANT_Long) {}
	void readinfo(input& i);
	void writedetail(output& o);
	unsigned long long get() const { return val_; }
private:
	unsigned long long val_;
};
//-------------------------------------------------------

class dblcpinfo: public cpinfo
{
public:
	dblcpinfo(): cpinfo(CONSTANT_Double) {}
	void readinfo(input& i);
	void writedetail(output& o);
	double get() const { return val_; }
private:
	double val_;
};
//------------------------------------------------------

class clscpinfo: public cpinfo
{
public:
	clscpinfo(): cpinfo(CONSTANT_Class) {}
	void readinfo(input& i);
	void writedetail(output& o);
	unsigned short nameidx() const { return nameidx_; }
private:
	unsigned short nameidx_;
};
//------------------------------------------------------
class strcpinfo: public cpinfo
{
public:
	strcpinfo(): cpinfo(CONSTANT_String) {}
	void readinfo(input& i);
	void writedetail(output& o);
	unsigned short get() const { return stridx_; }
private:
	unsigned short stridx_;
};
//------------------------------------------------------
class natcpinfo: public cpinfo
{
public:
	natcpinfo(): cpinfo(CONSTANT_NameAndType) {}
	void readinfo(input& i);
	void writedetail(output& o);
	unsigned short nameidx() const { return nameidx_; }
	void setnameidx(unsigned short idx) { nameidx_ = idx; }
	unsigned short descidx() const { return descidx_; }
private:
	unsigned short nameidx_;
	unsigned short descidx_;
};
//------------------------------------------------------
class refcpinfo: public cpinfo
{
public:
	refcpinfo(unsigned char tag): cpinfo(tag) {}
	void readinfo(input& i);
	void writedetail(output& o);
	unsigned short natindex() const { return natindex_;};
private:
	unsigned short classindex_;
	unsigned short natindex_;
};
//------------------------------------------------------
class fldrefcpinfo: public refcpinfo
{
public:
	fldrefcpinfo(): refcpinfo(CONSTANT_Fieldref){}
};

class imrefcpinfo: public refcpinfo
{
public:
	imrefcpinfo(): refcpinfo(CONSTANT_InterfaceMethodref) {};
};


class mrefcpinfo: public refcpinfo
{
public:
	mrefcpinfo(): refcpinfo(CONSTANT_Methodref) {};
};
//------------------------------------------------------