#include "StdAfx.h"
#include "cpinfo.h"
#include "input.h"
#include "output.h"

cpinfo::cpinfo(unsigned char tag): tag_(tag)
{
}


cpinfo::~cpinfo(void)
{
}

cpinfo* cpinfo::load(input& i)
{
	cpinfo* ci = 0;
	unsigned char c = i.readByte();
	switch(c)
	{
	case CONSTANT_Utf8:					ci = new utf8cpinfo(); break;
	case CONSTANT_Integer:				ci = new intcpinfo(); break;
	case CONSTANT_Float:				ci = new floatcpinfo(); break;
	case CONSTANT_Long:					ci = new longcpinfo(); break;
	case CONSTANT_Double:				ci = new dblcpinfo(); break;
	case CONSTANT_Class:				ci = new clscpinfo(); break;
	case CONSTANT_String:				ci = new strcpinfo(); break;
	case CONSTANT_Fieldref:				ci = new fldrefcpinfo(); break;
	case CONSTANT_Methodref:			ci = new mrefcpinfo(); break;
	case CONSTANT_InterfaceMethodref:	ci = new imrefcpinfo(); break;
	case CONSTANT_NameAndType:			ci = new natcpinfo(); break;

	default:
		throw "unknown cpinfo";
	}
	if(ci)
	{
		ci->readinfo(i);
	}
	return ci;
}

void cpinfo::writeinfo(output& o)
{
	o.writeByte(tag_);
	writedetail(o);
}

//-----------------------------------------------------
utf8cpinfo::utf8cpinfo(): cpinfo(CONSTANT_Utf8), data_(0), len_(0)
{
}

utf8cpinfo::utf8cpinfo(std::wstring name): cpinfo(CONSTANT_Utf8)
{
	len_ = name.length();
	data_ = new char[len_];
	for(unsigned short i = 0; i< len_; ++i)
	{
		data_[i] = (char)name.at(i);
	}

}

utf8cpinfo::~utf8cpinfo()
{
	clear();
}

void utf8cpinfo::clear()
{
	if(data_) { delete[] data_; }
	len_ = 0;
}

void utf8cpinfo::readinfo(input& i)
{
	clear();
	len_ = i.readShort();
	data_ = new char[len_] ;
	i.readArray(data_, len_);
}

void utf8cpinfo::writedetail(output& o)
{
	o.writeShort(len_);
	o.writeArray(data_, len_);
}

std::wstring utf8cpinfo::get() const
{
	std::wstring s;

	// todo utf8 encoding/decoding

	for(unsigned short i=0; i<len_; ++i) 
	{
		s += data_[i];
	}

	return s;
}

//------------------------------------------------------
void intcpinfo::readinfo(input& i)
{
	val_ = i.readInt();
}
void intcpinfo::writedetail(output& o)
{
	o.writeInt(val_);
}
//------------------------------------------------------
void floatcpinfo::readinfo(input& i)
{
	unsigned int f = i.readInt();
	val_ = (float)f;
}
void floatcpinfo::writedetail(output& o)
{
	o.writeInt((unsigned int)val_);
}
//------------------------------------------------------
void longcpinfo::readinfo(input& i)
{
	unsigned int v = i.readInt();
	val_ = ((unsigned long long)v) << 32;
	v = i.readInt();
	val_ |= v;
}
void longcpinfo::writedetail(output& o) 
{
	unsigned int v = val_ >> 32;
	o.writeInt(v);
	v = val_ & 0xFFFFFFFF;
	o.writeInt(v);

}
//-------------------------------------------------------
void dblcpinfo::readinfo(input& i)
{
	unsigned int v = i.readInt();
	unsigned long long l = ((unsigned long long)v) << 32;
	v = i.readInt();
	l |= v;
	val_ = (double)l;
}

void dblcpinfo::writedetail(output& o)
{
	unsigned int v = (unsigned long long) val_ >> 32;
	o.writeInt(v);
	v = (unsigned long long) val_ & 0xFFFFFFFF;
	o.writeInt(v);
}
//------------------------------------------------------
void clscpinfo::readinfo(input& i)
{
	nameidx_ = i.readShort();
}
void clscpinfo::writedetail(output& o)
{
	o.writeShort(nameidx_);
}
//------------------------------------------------------

void strcpinfo::readinfo(input& i)
{
	stridx_ = i.readShort();
}
void strcpinfo::writedetail(output& o)
{
	o.writeShort(stridx_);
}
//------------------------------------------------------
void natcpinfo::readinfo(input& i)
{
	nameidx_ = i.readShort();
	descidx_ = i.readShort();
}
void natcpinfo::writedetail(output& o)
{
	o.writeShort(nameidx_);
	o.writeShort(descidx_);
}
//------------------------------------------------------
void refcpinfo::readinfo(input& i)
{
	classindex_ = i.readShort();
	natindex_ = i.readShort();
}
void refcpinfo::writedetail(output& o)
{
	o.writeShort(classindex_);
	o.writeShort(natindex_);
}
