#include "StdAfx.h"
#include "clsiteminfo.h"

#include "input.h"
#include "output.h"
#include "attrinfo.h"

clsiteminfo::clsiteminfo(void)
{
}


clsiteminfo::~clsiteminfo(void)
{
	while(!attrs_.empty()) delete attrs_.back(), attrs_.pop_back();
}

void clsiteminfo::loadinfo(input& i, clazz& owner)
{
	accessflags_ = i.readShort();
	nameidx_    = i.readShort();
	descidx_    = i.readShort();
	unsigned short count = i.readShort();
	for(unsigned short i_=0; i_<count; ++i_)
	{
		attrinfo* info = attrinfo::load(i, owner);
		//todo: check synthetic
		attrs_.push_back(info);
	}
}

void clsiteminfo::saveinfo(output& o)
{
	o.writeShort(accessflags_);
	o.writeShort(nameidx_);
	o.writeShort(descidx_);
	unsigned short count = attrs_.size();
	o.writeShort(count);
	for(unsigned short i_=0; i_<count; ++i_)
	{
		attrinfo* info = attrs_.at(i_);
		info->saveinfo(o);
	}

}

unsigned short clsiteminfo::nameidx() const
{
	return nameidx_;
}
void clsiteminfo::setnameidx(unsigned short idx)
{
	nameidx_ = idx;
}

unsigned short clsiteminfo::descidx() const
{
	return descidx_;
}
void clsiteminfo::setdescidx(unsigned short idx)
{
	descidx_ = idx;
}

//-----------------------------------------------

void methinfo::removelocalvars()
{
	unsigned short i=0;
	while(i<attrs_.size())
	{
		codeattrinfo* info = dynamic_cast<codeattrinfo*> (attrs_.at(i++));
		if(info)
		{
			info->removelocalvars();
		}
	}
}
