#include "StdAfx.h"
#include "clazz.h"

#include "input.h"
#include "output.h"

#include "cpinfo.h"
#include "clsiteminfo.h"
#include "attrinfo.h"

clazz::clazz(const char* name)
{
	strcpy(name_, name);
	load(name);
}


clazz::~clazz(void)
{
	while(!cpool_.empty()) delete cpool_.back(), cpool_.pop_back();
	while(!fields_.empty()) delete fields_.back(), fields_.pop_back();
	while(!methods_.empty()) delete methods_.back(), methods_.pop_back();
	while(!attrs_.empty()) delete attrs_.back(), attrs_.pop_back();
}

void clazz::load(const char* name) {

	input i(name); // throws if no file

	magic_ = i.readInt();
	if( 0xCAFEBABE != magic_)
		throw "not a class";
	major_ = i.readShort();
	minor_ = i.readShort();

	unsigned short count;
	
	count = i.readShort();
	cpool_.push_back(0);
	for(unsigned short i_ = 1; i_ < count; ++i_) {
		cpinfo* info = cpinfo::load(i);
		cpool_.push_back(info);
		if(info->tag() == CONSTANT_Long || info->tag() == CONSTANT_Double)
		{
			cpool_.push_back(0); ++i_;
		}
	}
	accessflag_ = i.readShort();
	thiscls_ = i.readShort();
	supercls_ = i.readShort();

	count = i.readShort();
	for(unsigned short i_=0; i_ < count; ++ i_) {
		unsigned short intf = i.readShort();
		interfaces_.push_back(intf);
	}

	count = i.readShort();
	for(unsigned short i_=0; i_ < count; ++ i_) {
		fldinfo* info = new fldinfo();
		info->loadinfo(i, *this);
		fields_.push_back(info);
	}

	count = i.readShort();
	for(unsigned short i_=0; i_ < count; ++ i_) {
		methinfo* info = new methinfo();
		info->loadinfo(i, *this);
		methods_.push_back(info);
	}

	count = i.readShort();
	for(unsigned short i_=0; i_ < count; ++ i_) {
		attrinfo* info = attrinfo::load(i, *this);
		attrs_.push_back(info);
	}
}

void clazz::save(const char* name)
{
	output o(name? name: name_);
	o.writeInt(magic_);
	o.writeShort(major_);
	o.writeShort(minor_);
	unsigned short count = cpool_.size();
	o.writeShort(count);
	for(unsigned short i=0; i<count; ++i)
	{
		cpinfo* c = cpool_.at(i);
		if(c) c->writeinfo(o);
	}
	o.writeShort(accessflag_);
	o.writeShort(thiscls_);
	o.writeShort(supercls_);

	count = interfaces_.size();
	o.writeShort(count);
	for(unsigned short i=0; i<count; ++i)
	{
		o.writeShort(interfaces_.at(i));
	}

	count = fields_.size();
	o.writeShort(count);
	for(unsigned short i=0; i<count; ++i)
	{
		fldinfo* info = fields_.at(i);
		info->saveinfo(o);
	}

	count = methods_.size();
	o.writeShort(count);
	for(unsigned short i=0; i<count; ++i)
	{
		methinfo* info = methods_.at(i);
		info->saveinfo(o);
	}

	count = attrs_.size();
	o.writeShort(count);
	for(unsigned short i=0; i<count; ++i)
	{
		attrinfo* info = attrs_.at(i);
		info->saveinfo(o);
	}

}

cpinfo* clazz::getcpinfo(unsigned short idx)
{
	return cpool_.at(idx);
}

unsigned short clazz::addcpinfo(cpinfo* info)
{
	unsigned short cur = cpool_.size();
	cpool_.push_back(info);
	return cur;
}

void clazz::removelocalvars()
{
	unsigned short count = methods_.size();
	for(unsigned short i=0; i<count; i++)
	{
		methinfo* info = methods_.at(i);
		info->removelocalvars();
	}
}

std::wstring translate(std::wstring name)
{
	std::wstring result;
	for(size_t i=name.length()-1; i>0; --i)
	{
		if( name.at(i)==L'/' || (name.at(i) == L'L' && i==1))
		{
			result = name.substr(i+1, name.length()-i-1);
			return result;
		}
	}

	return name;
}

std::wstring clazz::demangle(std::wstring desc)
{
	if(desc.length() == 0) return L"";
	std::wstring result;

	if(desc.at(0) == L'(')
	{
		size_t pos = desc.find(L')');
		result = demangle( desc.substr(1, pos) );
		desc = desc.substr(pos+1);
	}

	while(desc.length())
	{
		switch( desc.at(0) )
		{
		case L'[':
			result += L"ar_";
			desc = desc.substr(1);
			break;
        case L'B':
        case L'C':
        case L'D':
        case L'F':
        case L'I':
        case L'J':
        case L'S':
        case L'Z':
        case L'V':
			result += desc.at(0);
			desc = desc.substr(1);
			break;
		case L')':
			result += L'v';
			desc = desc.substr(1);
			break;
		case L'L':
			{
			size_t pos = desc.find(L';');
			result += L'c' + translate( desc.substr(1, pos-1) );
			desc = desc.substr(pos+1);
			}
			break;
		default:
			desc = desc.substr(1);
			break;
		}
	}

	return result;
}

std::wstring clazz::rename(std::wstring name, std::wstring desc)
{
	std::wstring result = L'_' + name + L'_';

	result += demangle(desc);

	return result;
}


void clazz::renamefields()
{
	unsigned short count = fields_.size();
	for(unsigned short i=0; i<count; ++i)
	{
		fldinfo& field = *fields_.at(i);
		utf8cpinfo* utf = dynamic_cast<utf8cpinfo*>(getcpinfo( field.nameidx() ));
		if(utf) 
		{
			std::wstring name = utf->get();
			if(name.length() == 1)
			{
				utf8cpinfo* descutf = dynamic_cast<utf8cpinfo*>(getcpinfo( field.descidx() ));
				if(descutf)
				{
					std::wstring desc = descutf->get();
					std::wstring result = rename(name, desc);
					utf8cpinfo* newname = new utf8cpinfo(result);
					unsigned short newnameidx = addcpinfo(newname);
					field.setnameidx(newnameidx);
				}
			}
		}
	}

	count = cpool_.size();
	for(unsigned short i=1; i<count; ++i)
	{
		cpinfo* info = cpool_.at(i);
		if(info && info->tag() == CONSTANT_Fieldref)
		{
			fldrefcpinfo* fld = dynamic_cast<fldrefcpinfo*>(info);
			natcpinfo* nat = dynamic_cast<natcpinfo*>( getcpinfo( fld->natindex() ) );
			std::wstring name = dynamic_cast<utf8cpinfo*>( getcpinfo( nat->nameidx() ) )->get();
			std::wstring desc = dynamic_cast<utf8cpinfo*>( getcpinfo( nat->descidx() ) )->get();
			if(name.length() == 1)
			{
				std::wstring result = rename(name, desc);
				utf8cpinfo* newname = new utf8cpinfo(result);
				unsigned short newnameidx = addcpinfo(newname);
				nat->setnameidx(newnameidx);

			}
		}
	}
}