##TODO - should use relative paths
use File::Basename;


sub makeURLID {
  my $url = $_[0];
  $url =~ s/([^A-Za-z0-9])//seg;
  return $url;
}


  ## let's see if the arguments look right
  if (($#ARGV ne 0) || (!-e $ARGV[0])) {
    print "please pass the html0 file as a command line argument\n";
    exit;
  }
  
  $inFileName = $ARGV[0];
  my($filename, $directories, $suffix) = fileparse($inFileName, qr/\.[^.]*/);
  $outFileName = "$directories/$filename.mobi.html";

  #verify that there is a cover.jpg
 if (!-e "$directories/cover.jpg") {
    print "please verify that there is a cover.jpg image of the book cover\n";
    exit;
 }
  
 ## Open the file
  
  open (IN, $inFileName) || die $!;
  
  
  $parseHold = $/;
  $/ = undef;
  $contents = <IN>;
  close (IN);
  $/ = $parseHold;

#  if (($contents =~ m/<img.*src=[^\.]*\.png/i) || (($contents =~ m/<img.*src=[^\.]*\.gif/i))) {
#    print "Detected gif or png images in HTML0 document source.\nPlease convert to jpg and try again.";
#    exit;  
#  }
  
  #fix pagebreaks
  $contents =~ s/<hr>/<mbp:pagebreak\/>/sig;
  #now reference the table of contents in front of first pagebreak
  $contents =~ s/<mbp:pagebreak\/>/<p><a href="toc.html">TABLE OF CONTENTS<\/a><\/p>\n<mbp:pagebreak\/>/si;
  #get rid of justification
  $contents =~ s/align=justify//sig;
  #replace chapter titles with toc references
  $contents =~ s/<SPAN id=title>(<[^>]*>)*([^<]*)(<[^>]*>)*\n<\/SPAN>/<h2 id=\"$2\">$2<\/h2>/sig;

# (<h2 id=(?!BookTitle\b)(?!"BookTitle"\b))"*([^">]*)"*(.*)

#  $contents =~ s/<SPAN id=title>(<[^>]*>)*([^<]*)(<[^>]*>)*\n<\/SPAN>/<h2 id=\"$2\">$2<\/h2>/sig;
#  $contents =~ s/(<h2 id=(?!BookTitle\b)(?!"BookTitle"\b))"*([^">]*)"*(.*)/$1$3/sig;
  
  open FOUT, ">$outFileName";
  print FOUT $contents;
  close(FOUT);
  
  # re-open to build TOC, etc
  open (IN, $outFileName) || die $!;
  @contents = <IN>;
  close (IN);
  
  open FOUT, ">$directories/toc.html";

  print FOUT "<html>\n<body>\n<h2 align='center'>TABLE OF CONTENTS</h2>\n";
  
  my @revisedContents;
  foreach my $line (@contents) {
    if ($line =~ /<H2 id=BookTitle align=center>(<[^>]*>)*([^<]*)/i) {
        $title = $2;
    }
    elsif ($line =~ /<H2 id=BookAuthor[^>]*>(<[^>]*>)*([^<]*)/i) {
        $author = $2;
    }
    elsif ($line =~ /<h2 id=\"[^>]*>([^<]*)<\/h2>/i) {
        my $url = makeURLID($1);
        print FOUT "<a href='$filename.mobi.html#$url'>$1</a>\n<BR>";
        $line = "<h2 id=\"$url\">$1</h2>";
    }
    push @revisedContents, $line;
  }
  
  print FOUT "</body>\n\</html>";
  close(FOUT);

  open (FOUT, ">$outFileName") || die $!;
  print FOUT @revisedContents;
  close (FOUT);

  
  open FOUT, ">$directories/$filename.opf";
  print FOUT "<?xml version=\"1.0\" encoding=\"utf-8\"?>";
  print FOUT "<package unique-identifier=\"uid\">\n<metadata>\n<dc-metadata xmlns:dc=\"http://purl.org/metadata/dublin_core\" xmlns:oebpackage=\"http://openebook.org/namespaces/oeb-package/1.0/\">\n<dc:Title>$title</dc:Title>\n<dc:Language>en-us</dc:Language>\n<dc:Identifier id=\"uid\">C8C88F49DA</dc:Identifier>\n<dc:Creator>$author</dc:Creator>\n<dc:Subject BASICCode=\"FIC004000\">\n</dc:Subject>\n</dc-metadata>\n<x-metadata>\n<output encoding=\"Windows-1252\">\n</output>\n<EmbeddedCover>cover.jpg</EmbeddedCover>\n</x-metadata>\n</metadata>\n<manifest>\n<item id=\"item1\" media-type=\"text/x-oeb1-document\" href=\"$filename.mobi.html\">\n</item>\n<item id=\"item2\" media-type=\"text/x-oeb1-document\" href=\"toc.html\">\n</item>\n</manifest>\n<spine>\n<itemref idref=\"item1\"/>\n<itemref idref=\"item2\"/>\n</spine>\n<tours>\n</tours>\n<guide>\n<reference type=\"toc\" title=\"Table of Contents\" href=\"toc.html\">\n</reference>\n</guide>\n</package>";
  close(FOUT);
  
  

system "mobigen.exe", "$directories/$filename.opf", "-c1", "-s0", "-jpeg";

unlink "$directories/toc.html";  
unlink "$directories/$filename.opf";
unlink "$directories/$filename.mobi.html";

  print "done processing $title by $author \n";

  