#!/usr/bin/env python
# vim:fileencoding=UTF-8:ts=4:sw=4:sta:et:sts=4:ai
from __future__ import (unicode_literals, division, absolute_import,
                        print_function)

__license__   = 'GPL v3'
__copyright__ = '2012, Andrea Amorosi <Andrea.Amorosi76@gmail.com>'
__docformat__ = 'restructuredtext en'

#from calibre.ebooks.metadata import authors_to_string
from calibre.ebooks.metadata.book.base import Metadata
#from calibre.gui2 import error_dialog, question_dialog, Dispatcher
#from calibre.gui2.actions import InterfaceAction
#from calibre.gui2.dialogs.message_box import ErrorNotification

#import calibre_plugins.extract_isbn.config as cfg
#from calibre_plugins.extract_isbn.common_utils import set_plugin_icon_resources, get_icon
#from calibre_plugins.extract_isbn.dialogs import QueueProgressDialog
#from calibre_plugins.extract_isbn.jobs import (start_extract_threaded, get_job_details)

PLUGIN_ICONS = ['images/upperize_db.png']

class UpperizeDBAction(InterfaceAction):

    name = 'Upperize DB'
    # Create our top-level menu/toolbar action (text, icon_path, tooltip, keyboard shortcut)
    action_spec = ('Upperize DB', None, 'Trasforms all titles and authors in upper case', ())
    action_type = 'current'

    def genesis(self):
        # Read the plugin icons and store for potential sharing with the config widget
        icon_resources = self.load_resources(PLUGIN_ICONS)
        set_plugin_icon_resources(self.name, icon_resources)

        # Assign our menu to this action and an icon
        self.qaction.setIcon(get_icon(PLUGIN_ICONS[0]))
        self.qaction.triggered.connect(self.upperizedb)
        
    def upperizedb(self)
        db = self.gui.current_db
        bookids = db.search_getting_ids('title:"~[a-z]" or author:"~[a-z]"', None)

        for bookid in bookids:
            mi = db.get_metadata(bookid,index_is_id=True)
   
            mi.title = mi.title.upper()+'_T[##]'
            auths=[]
            for auth in mi.authors:
                auths.append(auth.upper()+'_T[##]')
            mi.authors = auths
            db.set_metadata(bookid,mi)
   
            mi = db.get_metadata(bookid,index_is_id=True)
   
            mi.title = mi.title[:-5]
            auths=[]
            for auth in mi.authors:
                auths.append(auth[:-5])
            mi.authors = auths
            db.set_metadata(bookid,mi)

        db.refresh_ids(bookids)
 