/*
 * Decompiled with CFR 0.152.
 */
package serp.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import java.util.LinkedList;
import serp.util.Numbers;

public class Strings {
    private static final Object[][] _codes = new Object[][]{{Byte.TYPE, "byte", "B"}, {Character.TYPE, "char", "C"}, {Double.TYPE, "double", "D"}, {Float.TYPE, "float", "F"}, {Integer.TYPE, "int", "I"}, {Long.TYPE, "long", "J"}, {Short.TYPE, "short", "S"}, {Boolean.TYPE, "boolean", "Z"}, {Void.TYPE, "void", "V"}};

    public static String replace(String string, String string2, String string3) {
        Object[] objectArray = Strings.split(string, string2, Integer.MAX_VALUE);
        return Strings.join(objectArray, string3);
    }

    public static String[] split(String string, String string2, int n) {
        if (string == null || string.length() == 0) {
            return new String[0];
        }
        if (string2 == null || string2.length() == 0) {
            throw new IllegalArgumentException("token: [" + string2 + "]");
        }
        LinkedList<String> linkedList = new LinkedList<String>();
        int n2 = 0;
        int n3 = 0;
        while (n3 != -1) {
            n3 = string.indexOf(string2, n2);
            if (n3 == -1 && n2 >= string.length()) {
                linkedList.add("");
                continue;
            }
            if (n3 == -1) {
                linkedList.add(string.substring(n2));
                continue;
            }
            linkedList.add(string.substring(n2, n3));
            n2 = n3 + string2.length();
        }
        if (n == 0) {
            while (linkedList.getLast().equals("")) {
                linkedList.removeLast();
            }
        } else if (n > 0 && linkedList.size() > n) {
            StringBuffer stringBuffer = new StringBuffer(linkedList.removeLast().toString());
            while (linkedList.size() >= n) {
                stringBuffer.insert(0, string2);
                stringBuffer.insert(0, linkedList.removeLast());
            }
            linkedList.add(stringBuffer.toString());
        }
        return linkedList.toArray(new String[linkedList.size()]);
    }

    public static String join(Object[] objectArray, String string) {
        if (objectArray == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(20 * objectArray.length);
        for (int i = 0; i < objectArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append(string);
            }
            if (objectArray[i] == null) continue;
            stringBuffer.append(objectArray[i]);
        }
        return stringBuffer.toString();
    }

    public static Class toClass(String string, ClassLoader classLoader) {
        return Strings.toClass(string, false, classLoader);
    }

    public static Class toClass(String string, boolean bl, ClassLoader classLoader) {
        int n;
        if (string == null) {
            throw new NullPointerException("str == null");
        }
        int n2 = 0;
        while (string.endsWith("[]")) {
            ++n2;
            string = string.substring(0, string.length() - 2);
        }
        boolean bl2 = false;
        if (string.indexOf(46) == -1) {
            for (n = 0; !bl2 && n < _codes.length; ++n) {
                if (!_codes[n][1].equals(string)) continue;
                if (n2 == 0) {
                    return (Class)_codes[n][0];
                }
                string = (String)_codes[n][2];
                bl2 = true;
            }
        }
        if (n2 > 0) {
            n = string.length() + n2;
            if (!bl2) {
                n += 2;
            }
            StringBuffer stringBuffer = new StringBuffer(n);
            for (int i = 0; i < n2; ++i) {
                stringBuffer.append('[');
            }
            if (!bl2) {
                stringBuffer.append('L');
            }
            stringBuffer.append(string);
            if (!bl2) {
                stringBuffer.append(';');
            }
            string = stringBuffer.toString();
        }
        if (classLoader == null) {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        try {
            return Class.forName(string, bl, classLoader);
        }
        catch (Throwable throwable) {
            throw new IllegalArgumentException(throwable.toString());
        }
    }

    public static String getClassName(Class clazz) {
        return clazz == null ? null : Strings.getClassName(clazz.getName());
    }

    public static String getClassName(String string) {
        int n;
        if (string == null) {
            return null;
        }
        int n2 = 0;
        for (n = 0; n < string.length(); ++n) {
            if (string.charAt(n) == '[') continue;
            n2 = n;
            break;
        }
        if (n2 > 0) {
            string = string.substring(n2);
        }
        for (n = 0; n < _codes.length; ++n) {
            if (!_codes[n][2].equals(string)) continue;
            string = (String)_codes[n][1];
            break;
        }
        string = string.substring(string.lastIndexOf(46) + 1);
        for (n = 0; n < n2; ++n) {
            string = string + "[]";
        }
        return string;
    }

    public static String getPackageName(Class clazz) {
        return clazz == null ? null : Strings.getPackageName(clazz.getName());
    }

    public static String getPackageName(String string) {
        if (string == null) {
            return null;
        }
        int n = string.lastIndexOf(46);
        return n == -1 ? "" : string.substring(0, n);
    }

    public static Object parse(String string, Class clazz) {
        if (!Strings.canParse(clazz)) {
            throw new IllegalArgumentException("invalid type: " + clazz.getName());
        }
        if (string == null) {
            if (!clazz.isPrimitive()) {
                return null;
            }
            if (clazz == Boolean.TYPE) {
                return Boolean.FALSE;
            }
            if (clazz == Byte.TYPE) {
                return new Byte(0);
            }
            if (clazz == Character.TYPE) {
                return new Character('\u0000');
            }
            if (clazz == Double.TYPE) {
                return new Double(0.0);
            }
            if (clazz == Float.TYPE) {
                return new Float(0.0f);
            }
            if (clazz == Integer.TYPE) {
                return Numbers.valueOf(0);
            }
            if (clazz == Long.TYPE) {
                return Numbers.valueOf(0L);
            }
            if (clazz == Short.TYPE) {
                return new Short(0);
            }
            throw new IllegalStateException("invalid type: " + clazz);
        }
        if (clazz == Boolean.TYPE || clazz == Boolean.class) {
            return Boolean.valueOf(string);
        }
        if (clazz == Byte.TYPE || clazz == Byte.class) {
            return Byte.valueOf(string);
        }
        if (clazz == Character.TYPE || clazz == Character.class) {
            if (string.length() == 0) {
                return new Character('\u0000');
            }
            if (string.length() == 1) {
                return new Character(string.charAt(0));
            }
            throw new IllegalArgumentException("'" + string + "' is longer than " + "one character.");
        }
        if (clazz == Double.TYPE || clazz == Double.class) {
            return Double.valueOf(string);
        }
        if (clazz == Float.TYPE || clazz == Float.class) {
            return Float.valueOf(string);
        }
        if (clazz == Integer.TYPE || clazz == Integer.class) {
            return Integer.valueOf(string);
        }
        if (clazz == Long.TYPE || clazz == Long.class) {
            return Long.valueOf(string);
        }
        if (clazz == Short.TYPE || clazz == Short.class) {
            return Short.valueOf(string);
        }
        if (clazz == String.class) {
            return string;
        }
        if (clazz == Date.class) {
            return new Date(string);
        }
        if (clazz == BigInteger.class) {
            return new BigInteger(string);
        }
        if (clazz == BigDecimal.class) {
            return new BigDecimal(string);
        }
        throw new IllegalArgumentException("Invalid type: " + clazz);
    }

    public static boolean canParse(Class clazz) {
        return clazz.isPrimitive() || clazz == Boolean.class || clazz == Byte.class || clazz == Character.class || clazz == Short.class || clazz == Integer.class || clazz == Long.class || clazz == Float.class || clazz == Double.class || clazz == String.class || clazz == Date.class || clazz == BigInteger.class || clazz == BigDecimal.class;
    }
}

