/*
 * Decompiled with CFR 0.152.
 */
package serp.bytecode.lowlevel;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import serp.bytecode.lowlevel.ConstantEntry;
import serp.bytecode.lowlevel.Entry;
import serp.bytecode.lowlevel.UTF8Entry;
import serp.bytecode.visitor.BCVisitor;

public class StringEntry
extends Entry
implements ConstantEntry {
    private int _stringIndex = -1;

    public StringEntry() {
    }

    public StringEntry(int n) {
        this._stringIndex = n;
    }

    public int getType() {
        return 8;
    }

    public int getStringIndex() {
        return this._stringIndex;
    }

    public void setStringIndex(int n) {
        Object object = this.beforeModify();
        this._stringIndex = n;
        this.afterModify(object);
    }

    public UTF8Entry getStringEntry() {
        return (UTF8Entry)this.getPool().getEntry(this._stringIndex);
    }

    public Object getConstant() {
        return this.getStringEntry().getValue();
    }

    public void setConstant(Object object) {
        this.getStringEntry().setConstant(object);
    }

    public void acceptVisit(BCVisitor bCVisitor) {
        bCVisitor.enterStringEntry(this);
        bCVisitor.exitStringEntry(this);
    }

    void readData(DataInput dataInput) throws IOException {
        this._stringIndex = dataInput.readUnsignedShort();
    }

    void writeData(DataOutput dataOutput) throws IOException {
        dataOutput.writeShort(this._stringIndex);
    }
}

