/*
 * Decompiled with CFR 0.152.
 */
package serp.bytecode.lowlevel;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import serp.bytecode.lowlevel.ClassEntry;
import serp.bytecode.lowlevel.ComplexEntry;
import serp.bytecode.lowlevel.ConstantEntry;
import serp.bytecode.lowlevel.DoubleEntry;
import serp.bytecode.lowlevel.Entry;
import serp.bytecode.lowlevel.FieldEntry;
import serp.bytecode.lowlevel.FloatEntry;
import serp.bytecode.lowlevel.IntEntry;
import serp.bytecode.lowlevel.InterfaceMethodEntry;
import serp.bytecode.lowlevel.LongEntry;
import serp.bytecode.lowlevel.MethodEntry;
import serp.bytecode.lowlevel.NameAndTypeEntry;
import serp.bytecode.lowlevel.StringEntry;
import serp.bytecode.lowlevel.UTF8Entry;
import serp.bytecode.visitor.BCVisitor;
import serp.bytecode.visitor.VisitAcceptor;
import serp.util.Numbers;

public class ConstantPool
implements VisitAcceptor {
    private List _entries = new ArrayList(50);
    private Map _lookup = new HashMap(50);

    public Entry[] getEntries() {
        ArrayList<Entry> arrayList = new ArrayList<Entry>(this._entries.size());
        Iterator iterator = this._entries.iterator();
        while (iterator.hasNext()) {
            Entry entry = (Entry)iterator.next();
            if (entry == null) continue;
            arrayList.add(entry);
        }
        return arrayList.toArray(new Entry[arrayList.size()]);
    }

    public Entry getEntry(int n) {
        Entry entry = (Entry)this._entries.get(n - 1);
        if (entry == null) {
            throw new IndexOutOfBoundsException("index = " + n);
        }
        return entry;
    }

    public int indexOf(Entry entry) {
        if (entry == null || entry.getPool() != this) {
            return 0;
        }
        return entry.getIndex();
    }

    public int addEntry(Entry entry) {
        if (entry.getPool() != this) {
            this.addEntry(ConstantPool.getKey(entry), entry);
        }
        return entry.getIndex();
    }

    private int addEntry(Object object, Entry entry) {
        entry.setPool(this);
        this._entries.add(entry);
        entry.setIndex(this._entries.size());
        this._lookup.put(object, entry);
        if (entry.isWide()) {
            this._entries.add(null);
        }
        return entry.getIndex();
    }

    public boolean removeEntry(Entry entry) {
        if (entry == null || entry.getPool() != this) {
            return false;
        }
        int n = entry.getIndex() - 1;
        entry.setPool(null);
        entry.setIndex(0);
        this._entries.remove(n);
        if (entry.isWide()) {
            this._entries.remove(n);
        }
        this._lookup.remove(ConstantPool.getKey(entry));
        for (int i = n; i < this._entries.size(); ++i) {
            entry = (Entry)this._entries.get(i);
            if (entry == null) continue;
            Object object = ConstantPool.getKey(entry);
            this._lookup.remove(object);
            entry.setIndex(i + 1);
            this._lookup.put(object, entry);
        }
        return true;
    }

    public void clear() {
        Iterator iterator = this._entries.iterator();
        while (iterator.hasNext()) {
            Entry entry = (Entry)iterator.next();
            if (entry == null) continue;
            entry.setPool(null);
            entry.setIndex(0);
        }
        this._entries.clear();
        this._lookup.clear();
    }

    public int size() {
        return this._entries.size();
    }

    public int findUTF8Entry(String string, boolean bl) {
        if (string == null) {
            if (bl) {
                throw new NullPointerException("value = null");
            }
            return 0;
        }
        int n = this.find(string);
        if (!bl || n > 0) {
            return n;
        }
        return this.addEntry(string, new UTF8Entry(string));
    }

    public int findDoubleEntry(double d, boolean bl) {
        Double d2 = new Double(d);
        int n = this.find(d2);
        if (!bl || n > 0) {
            return n;
        }
        return this.addEntry(d2, new DoubleEntry(d));
    }

    public int findFloatEntry(float f, boolean bl) {
        Float f2 = new Float(f);
        int n = this.find(f2);
        if (!bl || n > 0) {
            return n;
        }
        return this.addEntry(f2, new FloatEntry(f));
    }

    public int findIntEntry(int n, boolean bl) {
        Integer n2 = Numbers.valueOf(n);
        int n3 = this.find(n2);
        if (!bl || n3 > 0) {
            return n3;
        }
        return this.addEntry(n2, new IntEntry(n));
    }

    public int findLongEntry(long l, boolean bl) {
        Long l2 = Numbers.valueOf(l);
        int n = this.find(l2);
        if (!bl || n > 0) {
            return n;
        }
        return this.addEntry(l2, new LongEntry(l));
    }

    public int findStringEntry(String string, boolean bl) {
        int n = this.findUTF8Entry(string, bl);
        if (n == 0) {
            return 0;
        }
        StringKey stringKey = new StringKey(n);
        int n2 = this.find(stringKey);
        if (!bl || n2 > 0) {
            return n2;
        }
        return this.addEntry(stringKey, new StringEntry(n));
    }

    public int findClassEntry(String string, boolean bl) {
        int n = this.findUTF8Entry(string, bl);
        if (n == 0) {
            return 0;
        }
        ClassKey classKey = new ClassKey(n);
        int n2 = this.find(classKey);
        if (!bl || n2 > 0) {
            return n2;
        }
        return this.addEntry(classKey, new ClassEntry(n));
    }

    public int findNameAndTypeEntry(String string, String string2, boolean bl) {
        int n = this.findUTF8Entry(string, bl);
        if (n == 0) {
            return 0;
        }
        int n2 = this.findUTF8Entry(string2, bl);
        if (n2 == 0) {
            return 0;
        }
        NameAndTypeKey nameAndTypeKey = new NameAndTypeKey(n, n2);
        int n3 = this.find(nameAndTypeKey);
        if (!bl || n3 > 0) {
            return n3;
        }
        return this.addEntry(nameAndTypeKey, new NameAndTypeEntry(n, n2));
    }

    public int findFieldEntry(String string, String string2, String string3, boolean bl) {
        return this.findComplexEntry(string, string2, string3, 9, bl);
    }

    public int findMethodEntry(String string, String string2, String string3, boolean bl) {
        return this.findComplexEntry(string, string2, string3, 10, bl);
    }

    public int findInterfaceMethodEntry(String string, String string2, String string3, boolean bl) {
        return this.findComplexEntry(string, string2, string3, 11, bl);
    }

    private int findComplexEntry(String string, String string2, String string3, int n, boolean bl) {
        int n2 = this.findClassEntry(string, bl);
        if (n2 == 0) {
            return 0;
        }
        int n3 = this.findNameAndTypeEntry(string2, string3, bl);
        if (n3 == 0) {
            return 0;
        }
        DoublePtrKey doublePtrKey = null;
        switch (n) {
            case 9: {
                doublePtrKey = new FieldKey(n2, n3);
                break;
            }
            case 10: {
                doublePtrKey = new MethodKey(n2, n3);
                break;
            }
            case 11: {
                doublePtrKey = new InterfaceMethodKey(n2, n3);
            }
        }
        int n4 = this.find(doublePtrKey);
        if (!bl || n4 > 0) {
            return n4;
        }
        ComplexEntry complexEntry = null;
        switch (n) {
            case 9: {
                complexEntry = new FieldEntry(n2, n3);
                break;
            }
            case 10: {
                complexEntry = new MethodEntry(n2, n3);
                break;
            }
            case 11: {
                complexEntry = new InterfaceMethodEntry(n2, n3);
            }
        }
        return this.addEntry(doublePtrKey, complexEntry);
    }

    public void acceptVisit(BCVisitor bCVisitor) {
        bCVisitor.enterConstantPool(this);
        Iterator iterator = this._entries.iterator();
        while (iterator.hasNext()) {
            Entry entry = (Entry)iterator.next();
            if (entry == null) continue;
            bCVisitor.enterEntry(entry);
            entry.acceptVisit(bCVisitor);
            bCVisitor.exitEntry(entry);
        }
        bCVisitor.exitConstantPool(this);
    }

    public void read(DataInput dataInput) throws IOException {
        this.clear();
        int n = dataInput.readUnsignedShort();
        for (int i = 1; i < n; ++i) {
            Entry entry = Entry.read(dataInput);
            this.addEntry(entry);
            if (!entry.isWide()) continue;
            ++i;
        }
    }

    public void write(DataOutput dataOutput) throws IOException {
        dataOutput.writeShort(this._entries.size() + 1);
        Iterator iterator = this._entries.iterator();
        while (iterator.hasNext()) {
            Entry entry = (Entry)iterator.next();
            if (entry == null) continue;
            Entry.write(entry, dataOutput);
        }
    }

    void modifyEntry(Object object, Entry entry) {
        this._lookup.remove(object);
        this._lookup.put(ConstantPool.getKey(entry), entry);
    }

    private int find(Object object) {
        Entry entry = (Entry)this._lookup.get(object);
        if (entry == null) {
            return 0;
        }
        return entry.getIndex();
    }

    static Object getKey(Entry entry) {
        switch (entry.getType()) {
            case 7: {
                return new ClassKey(((ClassEntry)entry).getNameIndex());
            }
            case 9: {
                FieldEntry fieldEntry = (FieldEntry)entry;
                return new FieldKey(fieldEntry.getClassIndex(), fieldEntry.getNameAndTypeIndex());
            }
            case 10: {
                MethodEntry methodEntry = (MethodEntry)entry;
                return new MethodKey(methodEntry.getClassIndex(), methodEntry.getNameAndTypeIndex());
            }
            case 11: {
                InterfaceMethodEntry interfaceMethodEntry = (InterfaceMethodEntry)entry;
                return new InterfaceMethodKey(interfaceMethodEntry.getClassIndex(), interfaceMethodEntry.getNameAndTypeIndex());
            }
            case 8: {
                return new StringKey(((StringEntry)entry).getStringIndex());
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                return ((ConstantEntry)((Object)entry)).getConstant();
            }
            case 12: {
                NameAndTypeEntry nameAndTypeEntry = (NameAndTypeEntry)entry;
                return new NameAndTypeKey(nameAndTypeEntry.getNameIndex(), nameAndTypeEntry.getDescriptorIndex());
            }
        }
        return null;
    }

    private static class InterfaceMethodKey
    extends DoublePtrKey {
        public InterfaceMethodKey(int n, int n2) {
            super(n, n2);
        }
    }

    private static class MethodKey
    extends DoublePtrKey {
        public MethodKey(int n, int n2) {
            super(n, n2);
        }
    }

    private static class FieldKey
    extends DoublePtrKey {
        public FieldKey(int n, int n2) {
            super(n, n2);
        }
    }

    private static class NameAndTypeKey
    extends DoublePtrKey {
        public NameAndTypeKey(int n, int n2) {
            super(n, n2);
        }
    }

    private static abstract class DoublePtrKey {
        private final int _index1;
        private final int _index2;

        public DoublePtrKey(int n, int n2) {
            this._index1 = n;
            this._index2 = n2;
        }

        public int hashCode() {
            return this._index1 ^ this._index2;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object.getClass() != this.getClass()) {
                return false;
            }
            DoublePtrKey doublePtrKey = (DoublePtrKey)object;
            return doublePtrKey._index1 == this._index1 && doublePtrKey._index2 == this._index2;
        }
    }

    private static class ClassKey
    extends PtrKey {
        public ClassKey(int n) {
            super(n);
        }
    }

    private static class StringKey
    extends PtrKey {
        public StringKey(int n) {
            super(n);
        }
    }

    private static abstract class PtrKey {
        private final int _index;

        public PtrKey(int n) {
            this._index = n;
        }

        public int hashCode() {
            return this._index;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object.getClass() != this.getClass()) {
                return false;
            }
            return ((PtrKey)object)._index == this._index;
        }
    }
}

