/*
 * Decompiled with CFR 0.152.
 */
package serp.bytecode.lowlevel;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import serp.bytecode.lowlevel.ConstantEntry;
import serp.bytecode.lowlevel.Entry;
import serp.bytecode.lowlevel.UTF8Entry;
import serp.bytecode.visitor.BCVisitor;

public class ClassEntry
extends Entry
implements ConstantEntry {
    private int _nameIndex = 0;

    public ClassEntry() {
    }

    public ClassEntry(int n) {
        this._nameIndex = n;
    }

    public int getNameIndex() {
        return this._nameIndex;
    }

    public void setNameIndex(int n) {
        Object object = this.beforeModify();
        this._nameIndex = n;
        this.afterModify(object);
    }

    public UTF8Entry getNameEntry() {
        return (UTF8Entry)this.getPool().getEntry(this._nameIndex);
    }

    public int getType() {
        return 7;
    }

    public Object getConstant() {
        return this.getNameEntry().getValue();
    }

    public void setConstant(Object object) {
        this.getNameEntry().setConstant(object);
    }

    public void acceptVisit(BCVisitor bCVisitor) {
        bCVisitor.enterClassEntry(this);
        bCVisitor.exitClassEntry(this);
    }

    void readData(DataInput dataInput) throws IOException {
        this._nameIndex = dataInput.readUnsignedShort();
    }

    void writeData(DataOutput dataOutput) throws IOException {
        dataOutput.writeShort(this._nameIndex);
    }
}

