/*
 * Decompiled with CFR 0.152.
 */
package serp.bytecode;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import serp.bytecode.Code;
import serp.bytecode.Instruction;
import serp.bytecode.LocalVariableInstruction;
import serp.bytecode.TypedInstruction;
import serp.bytecode.visitor.BCVisitor;

public class StoreInstruction
extends LocalVariableInstruction {
    private static final Class[][] _mappings = new Class[][]{{Byte.TYPE, Integer.TYPE}, {Boolean.TYPE, Integer.TYPE}, {Character.TYPE, Integer.TYPE}, {Short.TYPE, Integer.TYPE}, {Void.TYPE, Integer.TYPE}};
    String _type = null;

    StoreInstruction(Code code) {
        super(code);
    }

    StoreInstruction(Code code, int n) {
        super(code, n);
    }

    int getLength() {
        switch (this.getOpcode()) {
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: {
                return super.getLength() + 1;
            }
        }
        return super.getLength();
    }

    public int getLogicalStackChange() {
        switch (this.getOpcode()) {
            case 0: {
                return 0;
            }
        }
        return -1;
    }

    public int getStackChange() {
        switch (this.getOpcode()) {
            case 55: 
            case 57: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 71: 
            case 72: 
            case 73: 
            case 74: {
                return -2;
            }
            case 0: {
                return 0;
            }
        }
        return -1;
    }

    public String getTypeName() {
        switch (this.getOpcode()) {
            case 54: 
            case 59: 
            case 60: 
            case 61: 
            case 62: {
                return Integer.TYPE.getName();
            }
            case 55: 
            case 63: 
            case 64: 
            case 65: 
            case 66: {
                return Long.TYPE.getName();
            }
            case 56: 
            case 67: 
            case 68: 
            case 69: 
            case 70: {
                return Float.TYPE.getName();
            }
            case 57: 
            case 71: 
            case 72: 
            case 73: 
            case 74: {
                return Double.TYPE.getName();
            }
            case 58: 
            case 75: 
            case 76: 
            case 77: 
            case 78: {
                return Object.class.getName();
            }
        }
        return this._type;
    }

    public TypedInstruction setType(String string) {
        string = this.mapType(string, _mappings, true);
        int n = this.getLocal();
        int n2 = this.getLength();
        if (string == null || n < 0) {
            this._type = string;
            this.setOpcode(0);
        } else {
            this._type = null;
            switch (string.charAt(0)) {
                case 'i': {
                    this.setOpcode(n > 3 ? 54 : 59 + n);
                    break;
                }
                case 'l': {
                    this.setOpcode(n > 3 ? 55 : 63 + n);
                    break;
                }
                case 'f': {
                    this.setOpcode(n > 3 ? 56 : 67 + n);
                    break;
                }
                case 'd': {
                    this.setOpcode(n > 3 ? 57 : 71 + n);
                    break;
                }
                default: {
                    this.setOpcode(n > 3 ? 58 : 75 + n);
                }
            }
        }
        if (n2 != this.getLength()) {
            this.invalidateByteIndexes();
        }
        return this;
    }

    public boolean equalsInstruction(Instruction instruction) {
        if (instruction == this) {
            return true;
        }
        if (!super.equalsInstruction(instruction)) {
            return false;
        }
        String string = this.getTypeName();
        String string2 = ((StoreInstruction)instruction).getTypeName();
        return string == null || string2 == null || string.equals(string2);
    }

    public void acceptVisit(BCVisitor bCVisitor) {
        bCVisitor.enterStoreInstruction(this);
        bCVisitor.exitStoreInstruction(this);
    }

    void read(Instruction instruction) {
        super.read(instruction);
        StoreInstruction storeInstruction = (StoreInstruction)instruction;
        this._type = storeInstruction._type;
    }

    void read(DataInput dataInput) throws IOException {
        super.read(dataInput);
        switch (this.getOpcode()) {
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: {
                this.setLocal(dataInput.readUnsignedByte());
            }
        }
    }

    void write(DataOutput dataOutput) throws IOException {
        super.write(dataOutput);
        switch (this.getOpcode()) {
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: {
                dataOutput.writeByte(this.getLocal());
            }
        }
    }

    void calculateOpcode() {
        this.setType(this.getTypeName());
    }

    void calculateLocal() {
        switch (this.getOpcode()) {
            case 59: 
            case 63: 
            case 67: 
            case 71: 
            case 75: {
                this.setLocal(0);
                break;
            }
            case 60: 
            case 64: 
            case 68: 
            case 72: 
            case 76: {
                this.setLocal(1);
                break;
            }
            case 61: 
            case 65: 
            case 69: 
            case 73: 
            case 77: {
                this.setLocal(2);
                break;
            }
            case 62: 
            case 66: 
            case 70: 
            case 74: 
            case 78: {
                this.setLocal(3);
            }
        }
    }
}

