/*
 * Decompiled with CFR 0.152.
 */
package serp.bytecode;

import serp.bytecode.Code;
import serp.bytecode.TypedInstruction;
import serp.bytecode.visitor.BCVisitor;

public class ReturnInstruction
extends TypedInstruction {
    private static final Class[][] _mappings = new Class[][]{{Byte.TYPE, Integer.TYPE}, {Character.TYPE, Integer.TYPE}, {Short.TYPE, Integer.TYPE}, {Boolean.TYPE, Integer.TYPE}};

    ReturnInstruction(Code code) {
        super(code);
    }

    ReturnInstruction(Code code, int n) {
        super(code, n);
    }

    public String getTypeName() {
        switch (this.getOpcode()) {
            case 172: {
                return Integer.TYPE.getName();
            }
            case 173: {
                return Long.TYPE.getName();
            }
            case 174: {
                return Float.TYPE.getName();
            }
            case 175: {
                return Double.TYPE.getName();
            }
            case 176: {
                return Object.class.getName();
            }
            case 177: {
                return Void.TYPE.getName();
            }
        }
        return null;
    }

    public TypedInstruction setType(String string) {
        if ((string = this.mapType(string, _mappings, true)) == null) {
            return (TypedInstruction)this.setOpcode(0);
        }
        switch (string.charAt(0)) {
            case 'i': {
                return (TypedInstruction)this.setOpcode(172);
            }
            case 'l': {
                return (TypedInstruction)this.setOpcode(173);
            }
            case 'f': {
                return (TypedInstruction)this.setOpcode(174);
            }
            case 'd': {
                return (TypedInstruction)this.setOpcode(175);
            }
            case 'v': {
                return (TypedInstruction)this.setOpcode(177);
            }
        }
        return (TypedInstruction)this.setOpcode(176);
    }

    public int getLogicalStackChange() {
        switch (this.getOpcode()) {
            case 0: {
                return 0;
            }
        }
        return -1;
    }

    public int getStackChange() {
        switch (this.getOpcode()) {
            case 0: 
            case 177: {
                return 0;
            }
            case 173: 
            case 175: {
                return -2;
            }
        }
        return -1;
    }

    public void acceptVisit(BCVisitor bCVisitor) {
        bCVisitor.enterReturnInstruction(this);
        bCVisitor.exitReturnInstruction(this);
    }
}

