/*
 * Decompiled with CFR 0.152.
 */
package serp.bytecode;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

public class NameCache {
    static final Object[][] _codes = new Object[][]{{Byte.TYPE, "B"}, {Character.TYPE, "C"}, {Double.TYPE, "D"}, {Float.TYPE, "F"}, {Integer.TYPE, "I"}, {Long.TYPE, "J"}, {Short.TYPE, "S"}, {Boolean.TYPE, "Z"}, {Void.TYPE, "V"}};
    private final Map _internal = new HashMap();
    private final Map _internalDescriptor = new HashMap();
    private final Map _external = new HashMap();
    private final Map _externalHuman = new HashMap();

    public String getInternalForm(String string, boolean bl) {
        if (string == null || string.length() == 0) {
            return string;
        }
        Map map = bl ? this._internalDescriptor : this._internal;
        String string2 = (String)map.get(string);
        if (string2 != null) {
            return string2;
        }
        String string3 = this.getInternalFormInternal(string, bl);
        map.put(string, string3);
        return string3;
    }

    private String getInternalFormInternal(String string, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        while (true) {
            if (string.endsWith("[]")) {
                stringBuffer.append("[");
                string = string.substring(0, string.length() - 2);
                continue;
            }
            if (!string.startsWith("[")) break;
            stringBuffer.append("[");
            string = string.substring(1);
        }
        for (int i = 0; i < _codes.length; ++i) {
            if (!string.equals(_codes[i][1].toString()) && !string.equals(_codes[i][0].toString())) continue;
            return stringBuffer.append(_codes[i][1]).toString();
        }
        if (string.startsWith("L") && string.endsWith(";")) {
            string = string.substring(1, string.length() - 1);
        }
        string = string.replace('.', '/');
        if ((bl || stringBuffer.length() > 0) && string.charAt(0) != '(') {
            return stringBuffer.append("L").append(string).append(";").toString();
        }
        return stringBuffer.append(string).toString();
    }

    public String getExternalForm(String string, boolean bl) {
        if (string == null || string.length() == 0) {
            return string;
        }
        Map map = bl ? this._externalHuman : this._external;
        String string2 = (String)map.get(string);
        if (string2 != null) {
            return string2;
        }
        String string3 = this.getExternalFormInternal(string, bl);
        map.put(string, string3);
        return string3;
    }

    private String getExternalFormInternal(String string, boolean bl) {
        if (!bl) {
            for (int i = 0; i < _codes.length; ++i) {
                if (string.equals(_codes[i][1].toString())) {
                    return _codes[i][0].toString();
                }
                if (!string.equals(_codes[i][0].toString())) continue;
                return string;
            }
            string = this.getInternalForm(string, false);
            return string.replace('/', '.');
        }
        StringBuffer stringBuffer = new StringBuffer(2);
        while (string.startsWith("[")) {
            string = string.substring(1);
            stringBuffer.append("[]");
        }
        if (string.endsWith(";")) {
            string = string.substring(1, string.length() - 1);
        }
        for (int i = 0; i < _codes.length; ++i) {
            if (!string.equals(_codes[i][1].toString())) continue;
            return _codes[i][0].toString() + stringBuffer;
        }
        return string.replace('/', '.') + stringBuffer;
    }

    public String getDescriptor(String string, String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(");
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i] == null) {
                    throw new NullPointerException("paramTypes[" + i + "] = null");
                }
                stringBuffer.append(this.getInternalForm(stringArray[i], true));
            }
        }
        stringBuffer.append(")");
        if (string == null) {
            throw new NullPointerException("returnType = null");
        }
        stringBuffer.append(this.getInternalForm(string, true));
        return stringBuffer.toString();
    }

    public String getDescriptorReturnName(String string) {
        int n = string.indexOf(41);
        if (n == -1) {
            return "";
        }
        return string.substring(string.indexOf(41) + 1);
    }

    public String[] getDescriptorParamNames(String string) {
        if (string == null || string.length() == 0) {
            return new String[0];
        }
        int n = string.indexOf(41);
        if (n == -1) {
            return new String[0];
        }
        string = string.substring(1, n);
        LinkedList<String> linkedList = new LinkedList<String>();
        while (string.length() > 0) {
            n = 0;
            while (!Character.isLetter(string.charAt(n))) {
                ++n;
            }
            if (string.charAt(n) == 'L') {
                n = string.indexOf(59);
            }
            linkedList.add(string.substring(0, n + 1));
            string = string.substring(n + 1);
        }
        return linkedList.toArray(new String[linkedList.size()]);
    }

    public String getComponentName(String string) {
        if (string == null || !string.startsWith("[")) {
            return null;
        }
        if (!(string = string.substring(1)).startsWith("[") && string.endsWith(";")) {
            string = string.substring(1, string.length() - 1);
        }
        return this.getExternalForm(string, false);
    }

    public void clear() {
        this._internal.clear();
        this._internalDescriptor.clear();
        this._external.clear();
        this._externalHuman.clear();
    }
}

