/*
 * Decompiled with CFR 0.152.
 */
package serp.bytecode;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import serp.bytecode.ClassInstruction;
import serp.bytecode.Code;
import serp.bytecode.Instruction;
import serp.bytecode.visitor.BCVisitor;

public class MultiANewArrayInstruction
extends ClassInstruction {
    private int _dims = -1;

    MultiANewArrayInstruction(Code code) {
        super(code, 197);
    }

    int getLength() {
        return super.getLength() + 1;
    }

    public int getStackChange() {
        return -this._dims + 1;
    }

    public int getDimensions() {
        return this._dims;
    }

    public MultiANewArrayInstruction setDimensions(int n) {
        this._dims = n;
        return this;
    }

    public boolean equalsInstruction(Instruction instruction) {
        if (instruction == this) {
            return true;
        }
        if (!(instruction instanceof MultiANewArrayInstruction)) {
            return false;
        }
        if (!super.equalsInstruction(instruction)) {
            return false;
        }
        MultiANewArrayInstruction multiANewArrayInstruction = (MultiANewArrayInstruction)instruction;
        int n = this.getDimensions();
        int n2 = multiANewArrayInstruction.getDimensions();
        return n == -1 || n2 == -1 || n == n2;
    }

    public void acceptVisit(BCVisitor bCVisitor) {
        bCVisitor.enterMultiANewArrayInstruction(this);
        bCVisitor.exitMultiANewArrayInstruction(this);
    }

    void read(Instruction instruction) {
        super.read(instruction);
        this._dims = ((MultiANewArrayInstruction)instruction).getDimensions();
    }

    void read(DataInput dataInput) throws IOException {
        super.read(dataInput);
        this._dims = dataInput.readUnsignedByte();
    }

    void write(DataOutput dataOutput) throws IOException {
        super.write(dataOutput);
        dataOutput.writeByte(this._dims);
    }
}

