/*
 * Decompiled with CFR 0.152.
 */
package serp.bytecode;

import serp.bytecode.Code;
import serp.bytecode.Instruction;
import serp.bytecode.TypedInstruction;
import serp.bytecode.visitor.BCVisitor;

public class MathInstruction
extends TypedInstruction {
    private static final Class[][] _mappings = new Class[][]{{Byte.TYPE, Integer.TYPE}, {Boolean.TYPE, Integer.TYPE}, {Character.TYPE, Integer.TYPE}, {Short.TYPE, Integer.TYPE}, {Void.TYPE, Integer.TYPE}, {Object.class, Integer.TYPE}};
    private int _op = -1;
    private String _type = null;

    MathInstruction(Code code) {
        super(code);
    }

    MathInstruction(Code code, int n) {
        super(code, n);
        this._op = this.getOperation();
    }

    public int getStackChange() {
        int n = this.getOperation();
        if (n == 116 || this.getOpcode() == 0) {
            return 0;
        }
        String string = this.getTypeName();
        if (Long.TYPE.getName().equals(string) || Double.TYPE.getName().equals(string)) {
            switch (this.getOpcode()) {
                case 121: 
                case 123: 
                case 125: {
                    return -1;
                }
            }
            return -2;
        }
        return -1;
    }

    public int getLogicalStackChange() {
        int n = this.getOperation();
        if (n == 116 || this.getOpcode() == 0) {
            return 0;
        }
        return -1;
    }

    public String getTypeName() {
        switch (this.getOpcode()) {
            case 96: 
            case 100: 
            case 104: 
            case 108: 
            case 112: 
            case 116: 
            case 120: 
            case 122: 
            case 124: 
            case 126: 
            case 128: 
            case 130: {
                return Integer.TYPE.getName();
            }
            case 97: 
            case 101: 
            case 105: 
            case 109: 
            case 113: 
            case 117: 
            case 121: 
            case 123: 
            case 125: 
            case 127: 
            case 129: 
            case 131: {
                return Long.TYPE.getName();
            }
            case 98: 
            case 102: 
            case 106: 
            case 110: 
            case 114: 
            case 118: {
                return Float.TYPE.getName();
            }
            case 99: 
            case 103: 
            case 107: 
            case 111: 
            case 115: 
            case 119: {
                return Double.TYPE.getName();
            }
        }
        return this._type;
    }

    public TypedInstruction setType(String string) {
        if ((string = this.mapType(string, _mappings, true)) == null || this._op < 0) {
            this._type = string;
            return (TypedInstruction)this.setOpcode(0);
        }
        this._type = null;
        switch (string.charAt(0)) {
            case 'i': {
                return (TypedInstruction)this.setOpcode(this._op);
            }
            case 'l': {
                return (TypedInstruction)this.setOpcode(this._op + 1);
            }
            case 'f': {
                return (TypedInstruction)this.setOpcode(this._op + 2);
            }
            case 'd': {
                return (TypedInstruction)this.setOpcode(this._op + 3);
            }
        }
        throw new IllegalStateException();
    }

    public MathInstruction setOperation(int n) {
        this._op = n;
        this.setType(this.getTypeName());
        return this;
    }

    public int getOperation() {
        switch (this.getOpcode()) {
            case 96: 
            case 97: 
            case 98: 
            case 99: {
                return 96;
            }
            case 100: 
            case 101: 
            case 102: 
            case 103: {
                return 100;
            }
            case 104: 
            case 105: 
            case 106: 
            case 107: {
                return 104;
            }
            case 108: 
            case 109: 
            case 110: 
            case 111: {
                return 108;
            }
            case 112: 
            case 113: 
            case 114: 
            case 115: {
                return 112;
            }
            case 116: 
            case 117: 
            case 118: 
            case 119: {
                return 116;
            }
            case 120: 
            case 121: {
                return 120;
            }
            case 122: 
            case 123: {
                return 122;
            }
            case 124: 
            case 125: {
                return 124;
            }
            case 126: 
            case 127: {
                return 126;
            }
            case 128: 
            case 129: {
                return 128;
            }
            case 130: 
            case 131: {
                return 130;
            }
        }
        return this._op;
    }

    public boolean equalsInstruction(Instruction instruction) {
        if (this == instruction) {
            return true;
        }
        if (!(instruction instanceof MathInstruction)) {
            return false;
        }
        MathInstruction mathInstruction = (MathInstruction)instruction;
        int n = this.getOperation();
        int n2 = mathInstruction.getOperation();
        boolean bl = n == -1 || n2 == -1 || n == n2;
        String string = this.getTypeName();
        String string2 = mathInstruction.getTypeName();
        boolean bl2 = string == null || string2 == null || string.equals(string2);
        return bl && bl2;
    }

    public void acceptVisit(BCVisitor bCVisitor) {
        bCVisitor.enterMathInstruction(this);
        bCVisitor.exitMathInstruction(this);
    }

    void read(Instruction instruction) {
        super.read(instruction);
        MathInstruction mathInstruction = (MathInstruction)instruction;
        this._type = mathInstruction._type;
        this._op = mathInstruction._op;
    }
}

