/*
 * Decompiled with CFR 0.152.
 */
package serp.bytecode;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import serp.bytecode.Attribute;
import serp.bytecode.Attributes;
import serp.bytecode.Code;
import serp.bytecode.Instruction;
import serp.bytecode.InstructionPtr;
import serp.bytecode.Local;

public abstract class LocalTable
extends Attribute
implements InstructionPtr {
    private List _locals = new ArrayList();

    LocalTable(int n, Attributes attributes) {
        super(n, attributes);
    }

    public Local[] getLocals() {
        return this._locals.toArray(this.newLocalArray(this._locals.size()));
    }

    public Local getLocal(int n) {
        for (int i = 0; i < this._locals.size(); ++i) {
            if (((Local)this._locals.get(i)).getLocal() != n) continue;
            return (Local)this._locals.get(i);
        }
        return null;
    }

    public Local getLocal(String string) {
        for (int i = 0; i < this._locals.size(); ++i) {
            String string2 = ((Local)this._locals.get(i)).getName();
            if ((string2 != null || string != null) && (string2 == null || !string2.equals(string))) continue;
            return (Local)this._locals.get(i);
        }
        return null;
    }

    public Local[] getLocals(String string) {
        LinkedList linkedList = new LinkedList();
        for (int i = 0; i < this._locals.size(); ++i) {
            String string2 = ((Local)this._locals.get(i)).getName();
            if ((string2 != null || string != null) && (string2 == null || !string2.equals(string))) continue;
            linkedList.add(this._locals.get(i));
        }
        return linkedList.toArray(this.newLocalArray(linkedList.size()));
    }

    public void setLocals(Local[] localArray) {
        this.clear();
        if (localArray != null) {
            for (int i = 0; i < localArray.length; ++i) {
                this.addLocal(localArray[i]);
            }
        }
    }

    public Local addLocal(Local local) {
        Local local2 = this.addLocal(local.getName(), local.getTypeName());
        local2.setStartPc(local.getStartPc());
        local2.setLength(local.getLength());
        return local2;
    }

    public Local addLocal() {
        Local local = this.newLocal();
        this._locals.add(local);
        return local;
    }

    protected abstract Local newLocal();

    protected abstract Local[] newLocalArray(int var1);

    public Local addLocal(String string, String string2) {
        Local local = this.addLocal();
        local.setName(string);
        local.setType(string2);
        return local;
    }

    public void clear() {
        for (int i = 0; i < this._locals.size(); ++i) {
            ((Local)this._locals.get(i)).invalidate();
        }
        this._locals.clear();
    }

    public boolean removeLocal(int n) {
        return this.removeLocal(this.getLocal(n));
    }

    public boolean removeLocal(String string) {
        return this.removeLocal(this.getLocal(string));
    }

    public boolean removeLocal(Local local) {
        if (local == null || !this._locals.remove(local)) {
            return false;
        }
        local.invalidate();
        return true;
    }

    public void updateTargets() {
        for (int i = 0; i < this._locals.size(); ++i) {
            ((Local)this._locals.get(i)).updateTargets();
        }
    }

    public void replaceTarget(Instruction instruction, Instruction instruction2) {
        for (int i = 0; i < this._locals.size(); ++i) {
            ((Local)this._locals.get(i)).replaceTarget(instruction, instruction2);
        }
    }

    public Code getCode() {
        return (Code)this.getOwner();
    }

    int getLength() {
        return 2 + 10 * this._locals.size();
    }

    void read(Attribute attribute) {
        this.setLocals(((LocalTable)attribute).getLocals());
    }

    void read(DataInput dataInput, int n) throws IOException {
        this.clear();
        int n2 = dataInput.readUnsignedShort();
        for (int i = 0; i < n2; ++i) {
            Local local = this.addLocal();
            local.read(dataInput);
        }
    }

    void write(DataOutput dataOutput, int n) throws IOException {
        dataOutput.writeShort(this._locals.size());
        for (int i = 0; i < this._locals.size(); ++i) {
            ((Local)this._locals.get(i)).write(dataOutput);
        }
    }
}

