/*
 * Decompiled with CFR 0.152.
 */
package serp.bytecode;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import serp.bytecode.BCEntity;
import serp.bytecode.Code;
import serp.bytecode.Instruction;
import serp.bytecode.InstructionPtr;
import serp.bytecode.InstructionPtrStrategy;
import serp.bytecode.LocalTable;
import serp.bytecode.Project;
import serp.bytecode.lowlevel.ConstantPool;
import serp.bytecode.lowlevel.UTF8Entry;

public abstract class Local
implements BCEntity,
InstructionPtr {
    private LocalTable _owner = null;
    private InstructionPtrStrategy _target = new InstructionPtrStrategy(this);
    private Instruction _end = null;
    private int _length = 0;
    private int _nameIndex = 0;
    private int _descriptorIndex = 0;
    private int _index = 0;

    Local(LocalTable localTable) {
        this._owner = localTable;
    }

    public LocalTable getTable() {
        return this._owner;
    }

    void invalidate() {
        this._owner = null;
    }

    public int getLocal() {
        return this._index;
    }

    public void setLocal(int n) {
        this._index = n;
    }

    public int getParam() {
        return this.getCode().getParamsIndex(this.getLocal());
    }

    public void setParam(int n) {
        this.setLocal(this._owner.getCode().getLocalsIndex(n));
    }

    public int getStartPc() {
        return this._target.getByteIndex();
    }

    public Instruction getStart() {
        return this._target.getTargetInstruction();
    }

    public void setStartPc(int n) {
        this._target.setByteIndex(n);
    }

    public void setStart(Instruction instruction) {
        this._target.setTargetInstruction(instruction);
    }

    public Instruction getEnd() {
        if (this._end != null) {
            return this._end;
        }
        int n = this._target.getByteIndex() + this._length;
        Instruction instruction = this.getCode().getInstruction(n);
        if (instruction != null && instruction.prev instanceof Instruction) {
            return (Instruction)instruction.prev;
        }
        return this.getCode().getLastInstruction();
    }

    public int getLength() {
        if (this._end != null) {
            return this._end.getByteIndex() + this._end.getLength() - this._target.getByteIndex();
        }
        return this._length;
    }

    public void setEnd(Instruction instruction) {
        if (instruction.getCode() != this.getCode()) {
            throw new IllegalArgumentException("Instruction pointers and targets must be part of the same code block.");
        }
        this._end = instruction;
        this._length = -1;
    }

    public void setLength(int n) {
        if (n < 0) {
            throw new IllegalArgumentException(String.valueOf(n));
        }
        this._length = n;
        this._end = null;
    }

    public void updateTargets() {
        this._target.updateTargets();
        this._end = this.getEnd();
    }

    public void replaceTarget(Instruction instruction, Instruction instruction2) {
        this._target.replaceTarget(instruction, instruction2);
        if (this.getEnd() == instruction) {
            this.setEnd(instruction2);
        }
    }

    public int getNameIndex() {
        return this._nameIndex;
    }

    public void setNameIndex(int n) {
        this._nameIndex = n;
    }

    public String getName() {
        if (this.getNameIndex() == 0) {
            return null;
        }
        return ((UTF8Entry)this.getPool().getEntry(this.getNameIndex())).getValue();
    }

    public void setName(String string) {
        if (string == null) {
            this.setNameIndex(0);
        } else {
            this.setNameIndex(this.getPool().findUTF8Entry(string, true));
        }
    }

    public int getTypeIndex() {
        return this._descriptorIndex;
    }

    public void setTypeIndex(int n) {
        this._descriptorIndex = n;
    }

    public String getTypeName() {
        if (this.getTypeIndex() == 0) {
            return null;
        }
        UTF8Entry uTF8Entry = (UTF8Entry)this.getPool().getEntry(this.getTypeIndex());
        return this.getProject().getNameCache().getExternalForm(uTF8Entry.getValue(), false);
    }

    public void setType(String string) {
        if (string == null) {
            this.setTypeIndex(0);
        } else {
            string = this.getProject().getNameCache().getInternalForm(string, true);
            this.setTypeIndex(this.getPool().findUTF8Entry(string, true));
        }
    }

    public Project getProject() {
        return this._owner.getProject();
    }

    public ConstantPool getPool() {
        return this._owner.getPool();
    }

    public ClassLoader getClassLoader() {
        return this._owner.getClassLoader();
    }

    public boolean isValid() {
        return this._owner != null;
    }

    void read(DataInput dataInput) throws IOException {
        this.setStartPc(dataInput.readUnsignedShort());
        this.setLength(dataInput.readUnsignedShort());
        this.setNameIndex(dataInput.readUnsignedShort());
        this.setTypeIndex(dataInput.readUnsignedShort());
        this.setLocal(dataInput.readUnsignedShort());
    }

    void write(DataOutput dataOutput) throws IOException {
        dataOutput.writeShort(this.getStartPc());
        dataOutput.writeShort(this.getLength());
        dataOutput.writeShort(this.getNameIndex());
        dataOutput.writeShort(this.getTypeIndex());
        dataOutput.writeShort(this.getLocal());
    }

    public Code getCode() {
        return this._owner.getCode();
    }
}

