/*
 * Decompiled with CFR 0.152.
 */
package serp.bytecode;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import serp.bytecode.Code;
import serp.bytecode.Instruction;
import serp.bytecode.LocalVariableInstruction;
import serp.bytecode.TypedInstruction;
import serp.bytecode.visitor.BCVisitor;

public class LoadInstruction
extends LocalVariableInstruction {
    private static final Class[][] _mappings = new Class[][]{{Byte.TYPE, Integer.TYPE}, {Boolean.TYPE, Integer.TYPE}, {Character.TYPE, Integer.TYPE}, {Short.TYPE, Integer.TYPE}, {Void.TYPE, Integer.TYPE}};
    String _type = null;

    LoadInstruction(Code code) {
        super(code);
    }

    LoadInstruction(Code code, int n) {
        super(code, n);
    }

    int getLength() {
        switch (this.getOpcode()) {
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                return super.getLength() + 1;
            }
        }
        return super.getLength();
    }

    public int getStackChange() {
        switch (this.getOpcode()) {
            case 22: 
            case 24: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                return 2;
            }
            case 0: {
                return 0;
            }
        }
        return 1;
    }

    public int getLogicalStackChange() {
        switch (this.getOpcode()) {
            case 0: {
                return 0;
            }
        }
        return 1;
    }

    public String getTypeName() {
        switch (this.getOpcode()) {
            case 21: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                return Integer.TYPE.getName();
            }
            case 22: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                return Long.TYPE.getName();
            }
            case 23: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                return Float.TYPE.getName();
            }
            case 24: 
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                return Double.TYPE.getName();
            }
            case 25: 
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                return Object.class.getName();
            }
        }
        return this._type;
    }

    public TypedInstruction setType(String string) {
        string = this.mapType(string, _mappings, true);
        int n = this.getLocal();
        int n2 = this.getLength();
        if (string == null || n < 0) {
            this._type = string;
            this.setOpcode(0);
        } else {
            this._type = null;
            switch (string.charAt(0)) {
                case 'i': {
                    this.setOpcode(n > 3 ? 21 : 26 + n);
                    break;
                }
                case 'l': {
                    this.setOpcode(n > 3 ? 22 : 30 + n);
                    break;
                }
                case 'f': {
                    this.setOpcode(n > 3 ? 23 : 34 + n);
                    break;
                }
                case 'd': {
                    this.setOpcode(n > 3 ? 24 : 38 + n);
                    break;
                }
                default: {
                    this.setOpcode(n > 3 ? 25 : 42 + n);
                }
            }
        }
        if (n2 != this.getLength()) {
            this.invalidateByteIndexes();
        }
        return this;
    }

    public LoadInstruction setThis() {
        return (LoadInstruction)this.setLocal(0).setType(Object.class);
    }

    public boolean isThis() {
        return this.getLocal() == 0 && this.getType() == Object.class;
    }

    public boolean equalsInstruction(Instruction instruction) {
        if (instruction == this) {
            return true;
        }
        if (!super.equalsInstruction(instruction)) {
            return false;
        }
        String string = this.getTypeName();
        String string2 = ((LoadInstruction)instruction).getTypeName();
        return string == null || string2 == null || string.equals(string2);
    }

    public void acceptVisit(BCVisitor bCVisitor) {
        bCVisitor.enterLoadInstruction(this);
        bCVisitor.exitLoadInstruction(this);
    }

    void read(Instruction instruction) {
        super.read(instruction);
        LoadInstruction loadInstruction = (LoadInstruction)instruction;
        this._type = loadInstruction._type;
    }

    void read(DataInput dataInput) throws IOException {
        super.read(dataInput);
        switch (this.getOpcode()) {
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                this.setLocal(dataInput.readUnsignedByte());
            }
        }
    }

    void write(DataOutput dataOutput) throws IOException {
        super.write(dataOutput);
        switch (this.getOpcode()) {
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                dataOutput.writeByte(this.getLocal());
            }
        }
    }

    void calculateOpcode() {
        this.setType(this.getTypeName());
    }

    void calculateLocal() {
        switch (this.getOpcode()) {
            case 26: 
            case 30: 
            case 34: 
            case 38: 
            case 42: {
                this.setLocal(0);
                break;
            }
            case 27: 
            case 31: 
            case 35: 
            case 39: 
            case 43: {
                this.setLocal(1);
                break;
            }
            case 28: 
            case 32: 
            case 36: 
            case 40: 
            case 44: {
                this.setLocal(2);
                break;
            }
            case 29: 
            case 33: 
            case 37: 
            case 41: 
            case 45: {
                this.setLocal(3);
            }
        }
    }
}

