/*
 * Decompiled with CFR 0.152.
 */
package serp.bytecode;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import serp.bytecode.Code;
import serp.bytecode.Instruction;
import serp.bytecode.InstructionPtr;
import serp.bytecode.InstructionPtrStrategy;
import serp.bytecode.visitor.BCVisitor;

public abstract class JumpInstruction
extends Instruction
implements InstructionPtr {
    private InstructionPtrStrategy _target = new InstructionPtrStrategy(this);

    JumpInstruction(Code code, int n) {
        super(code, n);
    }

    public Instruction getTarget() {
        return this._target.getTargetInstruction();
    }

    public JumpInstruction setTarget(Instruction instruction) {
        this._target.setTargetInstruction(instruction);
        return this;
    }

    public boolean equalsInstruction(Instruction instruction) {
        if (this == instruction) {
            return true;
        }
        if (!super.equalsInstruction(instruction)) {
            return false;
        }
        Instruction instruction2 = ((JumpInstruction)instruction).getTarget();
        return instruction2 == null || this.getTarget() == null || instruction2 == this.getTarget();
    }

    public void updateTargets() {
        this._target.updateTargets();
    }

    public void replaceTarget(Instruction instruction, Instruction instruction2) {
        this._target.replaceTarget(instruction, instruction2);
    }

    public void acceptVisit(BCVisitor bCVisitor) {
        bCVisitor.enterJumpInstruction(this);
        bCVisitor.exitJumpInstruction(this);
    }

    void read(Instruction instruction) {
        super.read(instruction);
        this._target.setByteIndex(((JumpInstruction)instruction)._target.getByteIndex());
    }

    void read(DataInput dataInput) throws IOException {
        super.read(dataInput);
        switch (this.getOpcode()) {
            case 200: 
            case 201: {
                this._target.setByteIndex(this.getByteIndex() + dataInput.readInt());
                break;
            }
            default: {
                this._target.setByteIndex(this.getByteIndex() + dataInput.readShort());
            }
        }
    }

    void write(DataOutput dataOutput) throws IOException {
        super.write(dataOutput);
        switch (this.getOpcode()) {
            case 200: 
            case 201: {
                dataOutput.writeInt(this._target.getByteIndex() - this.getByteIndex());
                break;
            }
            default: {
                dataOutput.writeShort(this._target.getByteIndex() - this.getByteIndex());
            }
        }
    }

    public void setOffset(int n) {
        this._target.setByteIndex(this.getByteIndex() + n);
    }

    public int getOffset() {
        return this._target.getByteIndex() - this.getByteIndex();
    }
}

